/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.configuration.transformation;

import io.papermc.paper.configuration.Configurations;
import io.papermc.paper.configuration.type.number.DoubleOr;
import java.util.OptionalDouble;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.purpurmc.purpur.PurpurConfig;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public class VoidDamageHeightMigration
implements TransformAction {
    public static boolean HAS_BEEN_REGISTERED = false;
    public static final String ENVIRONMENT_KEY = "environment";
    public static final String VOID_DAMAGE_KEY = "void-damage-amount";
    public static final String VOID_DAMAGE_MIN_HEIGHT_OFFSET_KEY = "void-damage-min-build-height-offset";
    public static final double DEFAULT_VOID_DAMAGE_HEIGHT = -64.0;
    public static final double DEFAULT_VOID_DAMAGE = 4.0;
    private final String worldName;

    private VoidDamageHeightMigration(String worldName) {
        this.worldName = "__world_defaults__".equals(worldName) ? "default" : worldName;
    }

    public Object @Nullable [] visitPath(NodePath path, ConfigurationNode value) throws ConfigurateException {
        String purpurVoidDamageHeightPath = "world-settings." + this.worldName + ".gameplay-mechanics.void-damage-height";
        ConfigurationNode voidDamageMinHeightOffsetNode = value.node(new Object[]{ENVIRONMENT_KEY, VOID_DAMAGE_MIN_HEIGHT_OFFSET_KEY});
        if (PurpurConfig.config.contains(purpurVoidDamageHeightPath)) {
            double purpurVoidDamageHeight = PurpurConfig.config.getDouble(purpurVoidDamageHeightPath);
            if (purpurVoidDamageHeight != -64.0 && (voidDamageMinHeightOffsetNode.empty() || voidDamageMinHeightOffsetNode.getDouble() == -64.0)) {
                voidDamageMinHeightOffsetNode.raw(null);
                voidDamageMinHeightOffsetNode.set((Object)purpurVoidDamageHeight);
            }
            PurpurConfig.config.set(purpurVoidDamageHeightPath, null);
        }
        String purpurVoidDamagePath = "world-settings." + this.worldName + ".gameplay-mechanics.void-damage-dealt";
        ConfigurationNode voidDamageNode = value.node(new Object[]{ENVIRONMENT_KEY, VOID_DAMAGE_KEY});
        if (PurpurConfig.config.contains(purpurVoidDamagePath)) {
            double purpurVoidDamage = PurpurConfig.config.getDouble(purpurVoidDamagePath);
            if (purpurVoidDamage != 4.0 && (voidDamageNode.empty() || voidDamageNode.getDouble() == 4.0)) {
                voidDamageNode.raw(null);
                voidDamageNode.set((Object)new DoubleOr.Disabled(OptionalDouble.of(purpurVoidDamage)));
            }
            PurpurConfig.config.set(purpurVoidDamagePath, null);
        }
        return null;
    }

    public static void apply(ConfigurationTransformation.Builder builder, Configurations.ContextMap contextMap) {
        if (PurpurConfig.version < 36) {
            HAS_BEEN_REGISTERED = true;
            builder.addAction(NodePath.path(), (TransformAction)new VoidDamageHeightMigration(contextMap.require(Configurations.WORLD_NAME)));
        }
    }
}

