/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.entity;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityRemoveEvent;

public class PhantomFlames
extends LlamaSpit {
    public Phantom phantom;
    public int ticksLived;
    public boolean canGrief = false;

    public PhantomFlames(EntityType<? extends LlamaSpit> type, Level world) {
        super(type, world);
    }

    public PhantomFlames(Level world, Phantom phantom) {
        this((EntityType<? extends LlamaSpit>)EntityType.LLAMA_SPIT, world);
        this.setOwner(phantom.getRider() != null ? phantom.getRider() : phantom);
        this.phantom = phantom;
        this.setPos(phantom.getX() - (double)(phantom.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin(phantom.yBodyRot * ((float)Math.PI / 180)), phantom.getEyeY() - (double)0.1f, phantom.getZ() + (double)(phantom.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos(phantom.yBodyRot * ((float)Math.PI / 180)));
    }

    @Override
    public boolean canSaveToDisk() {
        return false;
    }

    @Override
    public void tick() {
        this.super_tick();
        Vec3 mot = this.getDeltaMovement();
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        this.preHitTargetOrDeflectSelf(hitResult);
        double x = this.getX() + mot.x;
        double y = this.getY() + mot.y;
        double z = this.getZ() + mot.z;
        this.updateRotation();
        Vec3 motDouble = mot.scale(2.0);
        for (int i = 0; i < 5; ++i) {
            ((ServerLevel)this.level()).sendParticles(null, ParticleTypes.FLAME, this.getX() + (double)(this.random.nextFloat() / 2.0f) - 0.25, this.getY() + (double)(this.random.nextFloat() / 2.0f) - 0.25, this.getZ() + (double)(this.random.nextFloat() / 2.0f) - 0.25, 0, motDouble.x(), motDouble.y(), motDouble.z(), 0.1, true);
        }
        if (++this.ticksLived > 20) {
            this.discard(EntityRemoveEvent.Cause.DISCARD);
        } else if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBehaviour.BlockStateBase::isAir)) {
            this.discard(EntityRemoveEvent.Cause.DISCARD);
        } else if (this.isInWaterOrBubble()) {
            this.discard(EntityRemoveEvent.Cause.DISCARD);
        } else {
            this.setDeltaMovement(mot.scale(0.99));
            if (!this.isNoGravity()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.06, 0.0));
            }
            this.setPos(x, y, z);
        }
    }

    @Override
    public void shoot(double x, double y, double z, float speed, float inaccuracy) {
        this.setDeltaMovement(new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale(speed));
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Entity shooter = this.getOwner();
            if (shooter instanceof LivingEntity) {
                boolean hurt;
                Entity target = entityHitResult.getEntity();
                if ((this.canGrief || target instanceof LivingEntity && !(target instanceof ArmorStand)) && (hurt = target.hurtServer(worldserver, target.damageSources().mobProjectile(this, (LivingEntity)shooter), worldserver.purpurConfig.phantomFlameDamage)) && worldserver.purpurConfig.phantomFlameFireTime > 0) {
                    target.igniteForSeconds(worldserver.purpurConfig.phantomFlameFireTime);
                }
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult blockHitResult) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (this.hitCancelled) {
                return;
            }
            if (this.canGrief) {
                BlockState state = worldserver.getBlockState(blockHitResult.getBlockPos());
                state.onProjectileHit(worldserver, state, blockHitResult, this);
            }
            this.discard(EntityRemoveEvent.Cause.DISCARD);
        }
    }
}

