/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.task;

import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginBase;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import org.purpurmc.purpur.network.ClientboundBeehivePayload;
import org.purpurmc.purpur.network.ServerboundBeehivePayload;
import org.purpurmc.purpur.util.MinecraftInternalPlugin;

public class BeehiveTask
implements PluginMessageListener {
    private static BeehiveTask instance;
    private final PluginBase plugin = new MinecraftInternalPlugin();

    public static BeehiveTask instance() {
        if (instance == null) {
            instance = new BeehiveTask();
        }
        return instance;
    }

    private BeehiveTask() {
    }

    public void register() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, ClientboundBeehivePayload.TYPE.id().toString());
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, ServerboundBeehivePayload.TYPE.id().toString(), (PluginMessageListener)this);
    }

    public void unregister() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this.plugin, ClientboundBeehivePayload.TYPE.id().toString());
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this.plugin, ServerboundBeehivePayload.TYPE.id().toString());
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte[] bytes) {
        FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.copiedBuffer((byte[])bytes));
        ServerboundBeehivePayload payload = (ServerboundBeehivePayload)ServerboundBeehivePayload.STREAM_CODEC.decode(byteBuf);
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (!payload.pos().getCenter().closerThan(serverPlayer.position(), 20.0)) {
            return;
        }
        if (serverPlayer.level().getChunkIfLoaded(payload.pos()) == null) {
            return;
        }
        BlockEntity blockEntity = serverPlayer.level().getBlockEntity(payload.pos());
        if (!(blockEntity instanceof BeehiveBlockEntity)) {
            return;
        }
        BeehiveBlockEntity beehive = (BeehiveBlockEntity)blockEntity;
        ClientboundBeehivePayload customPacketPayload = new ClientboundBeehivePayload(payload.pos(), beehive.getOccupantCount());
        FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(Unpooled.buffer());
        ClientboundBeehivePayload.STREAM_CODEC.encode(friendlyByteBuf, customPacketPayload);
        byte[] byteArray = new byte[friendlyByteBuf.readableBytes()];
        friendlyByteBuf.readBytes(byteArray);
        player.sendPluginMessage((Plugin)this.plugin, customPacketPayload.type().id().toString(), byteArray);
    }
}

