/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.command;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class UnknownCommandEvent
extends Event {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final CommandSender sender;
    private final String commandLine;
    private @Nullable Component message;

    @ApiStatus.Internal
    public UnknownCommandEvent(CommandSender sender, String commandLine, @Nullable Component message) {
        super(false);
        this.sender = sender;
        this.commandLine = commandLine;
        this.message = message;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    @Deprecated
    public @Nullable String getMessage() {
        return this.message == null ? null : LegacyComponentSerializer.legacySection().serialize(this.message);
    }

    @Deprecated
    public void setMessage(@Nullable String message) {
        this.message((Component)(message == null ? null : LegacyComponentSerializer.legacySection().deserialize(message)));
    }

    @Contract(pure=true)
    public @Nullable Component message() {
        return this.message;
    }

    public void message(@Nullable Component message) {
        this.message = message;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

