/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import com.google.common.base.Preconditions;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlayerJumpEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    @NotNull
    private final Location to;
    @NotNull
    private Location from;
    private boolean cancelled;

    @ApiStatus.Internal
    public PlayerJumpEvent(@NotNull Player player, @NotNull Location from, @NotNull Location to) {
        super(player);
        this.from = from;
        this.to = to;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    public Location getFrom() {
        return this.from;
    }

    public void setFrom(@NotNull Location from) {
        Preconditions.checkArgument((from != null ? 1 : 0) != 0, (Object)"Cannot use null from location!");
        Preconditions.checkArgument((from.getWorld() != null ? 1 : 0) != 0, (Object)"Cannot use from location with null world!");
        this.from = from;
    }

    @NotNull
    public Location getTo() {
        return this.to.clone();
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

