/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.builder;

import io.papermc.asm.rules.builder.ConfiguredRuleFactoryImpl;
import io.papermc.asm.rules.builder.RuleFactory;
import io.papermc.asm.rules.builder.RuleFactoryConfiguration;
import io.papermc.asm.rules.builder.matcher.MethodMatcher;
import io.papermc.asm.rules.builder.matcher.TargetedMethodMatcher;
import io.papermc.asm.util.DescriptorUtils;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Consumer;

public interface ConfiguredRuleFactory
extends RuleFactory {
    public static ConfiguredRuleFactory create(Set<Class<?>> owners, RuleFactoryConfiguration config) {
        return new ConfiguredRuleFactoryImpl(owners, config);
    }

    public static Factory combine(Factory ... factories) {
        return r -> {
            for (Factory factory : factories) {
                factory.accept(r);
            }
        };
    }

    public void plainStaticRewrite(Consumer<? super MethodMatcher.Builder> var1);

    default public void changeParamFuzzy(Class<?> newParamType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeParamFuzzy(DescriptorUtils.desc(newParamType), staticHandler, builderConsumer);
    }

    public void changeParamFuzzy(ClassDesc var1, Method var2, Consumer<? super TargetedMethodMatcher.Builder> var3);

    default public void changeParamDirect(Class<?> newParamType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeParamDirect(DescriptorUtils.desc(newParamType), staticHandler, builderConsumer);
    }

    public void changeParamDirect(ClassDesc var1, Method var2, Consumer<? super TargetedMethodMatcher.Builder> var3);

    default public void changeReturnTypeFuzzy(Class<?> newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeReturnTypeFuzzy(DescriptorUtils.desc(newReturnType), staticHandler, builderConsumer);
    }

    public void changeReturnTypeFuzzy(ClassDesc var1, Method var2, Consumer<? super TargetedMethodMatcher.Builder> var3);

    default public void changeReturnTypeDirect(Class<?> newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeReturnTypeDirect(DescriptorUtils.desc(newReturnType), staticHandler, builderConsumer);
    }

    public void changeReturnTypeDirect(ClassDesc var1, Method var2, Consumer<? super TargetedMethodMatcher.Builder> var3);

    default public void changeReturnTypeFuzzyWithContext(Class<?> newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeReturnTypeFuzzyWithContext(DescriptorUtils.desc(newReturnType), staticHandler, builderConsumer);
    }

    public void changeReturnTypeFuzzyWithContext(ClassDesc var1, Method var2, Consumer<? super TargetedMethodMatcher.Builder> var3);

    default public void changeReturnTypeDirectWithContext(Class<?> newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeReturnTypeDirectWithContext(DescriptorUtils.desc(newReturnType), staticHandler, builderConsumer);
    }

    public void changeReturnTypeDirectWithContext(ClassDesc var1, Method var2, Consumer<? super TargetedMethodMatcher.Builder> var3);

    @FunctionalInterface
    public static interface Factory
    extends Consumer<ConfiguredRuleFactory> {
        @Override
        public void accept(ConfiguredRuleFactory var1);
    }
}

