/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.builder.matcher;

import io.papermc.asm.rules.builder.matcher.MethodMatcher;
import io.papermc.asm.rules.builder.matcher.TargetedMethodMatcherImpl;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public interface TargetedMethodMatcher
extends MethodMatcher {
    public ClassDesc targetType();

    public static class Builder
    implements io.papermc.asm.util.Builder<TargetedMethodMatcher> {
        private Predicate<String> byName = $ -> false;
        private Predicate<MethodTypeDesc> byDesc = $ -> false;
        private @MonotonicNonNull ClassDesc oldType;

        Builder() {
        }

        public Builder names(String ... names) {
            return this.names(List.of(names));
        }

        public Builder names(Collection<String> names) {
            this.byName = this.byName.or(names::contains);
            return this;
        }

        public Builder containsParam(ClassDesc classDesc) {
            this.oldType = classDesc;
            this.byDesc = d -> d.parameterList().contains(classDesc);
            return this;
        }

        public Builder hasReturn(ClassDesc classDesc) {
            this.oldType = classDesc;
            this.byDesc = d -> d.returnType().equals(classDesc);
            return this;
        }

        public Builder desc(Predicate<? super MethodTypeDesc> predicate) {
            this.byDesc = this.byDesc.and(predicate);
            return this;
        }

        @Override
        public TargetedMethodMatcher build() {
            return new TargetedMethodMatcherImpl(this.byName, this.byDesc, Objects.requireNonNull(this.oldType));
        }
    }
}

