/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.method;

import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.util.DescriptorUtils;
import java.lang.constant.MethodTypeDesc;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;

public interface MethodRewriteRule
extends RewriteRule {
    public static final String LAMBDA_METAFACTORY_OWNER = "java/lang/invoke/LambdaMetafactory";

    default public boolean shouldProcess(ClassProcessingContext context, int opcode, String owner, String name, String descriptor, boolean isInterface) {
        return true;
    }

    @Override
    default public ClassVisitor createVisitor(int api, ClassVisitor parent, final ClassProcessingContext context) {
        return new ClassVisitor(api, parent){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                final MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                final MethodNode mn = new MethodNode(this.api, access, name, descriptor, signature, exceptions);
                return new MethodVisitor(this.api, (MethodVisitor)mn){

                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        Rewrite rewrite;
                        if (MethodRewriteRule.this.shouldProcess(context, opcode, owner, name, descriptor, isInterface) && (rewrite = MethodRewriteRule.this.rewrite(context, false, opcode, owner, name, DescriptorUtils.methodDesc(descriptor), isInterface)) != null) {
                            rewrite.apply(this.getDelegate(), mn);
                            return;
                        }
                        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                    }

                    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                        Rewrite rewrite;
                        Handle handle;
                        Object object;
                        if (MethodRewriteRule.LAMBDA_METAFACTORY_OWNER.equals(bootstrapMethodHandle.getOwner()) && bootstrapMethodArguments.length > 1 && (object = bootstrapMethodArguments[1]) instanceof Handle && MethodRewriteRule.this.shouldProcess(context, (handle = (Handle)object).getTag(), handle.getOwner(), handle.getName(), handle.getDesc(), handle.isInterface()) && (rewrite = MethodRewriteRule.this.rewrite(context, true, handle.getTag(), handle.getOwner(), handle.getName(), DescriptorUtils.methodDesc(handle.getDesc()), handle.isInterface())) != null) {
                            bootstrapMethodArguments[1] = rewrite.createHandle();
                        }
                        super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
                    }

                    public void visitEnd() {
                        mn.accept(methodVisitor);
                        super.visitEnd();
                    }
                };
            }
        };
    }

    public @Nullable Rewrite rewrite(ClassProcessingContext var1, boolean var2, int var3, String var4, String var5, MethodTypeDesc var6, boolean var7);

    public record RewriteSingle(int opcode, String owner, String name, MethodTypeDesc descriptor, boolean isInterface) implements Rewrite
    {
        @Override
        public void apply(MethodVisitor delegate, MethodNode context) {
            delegate.visitMethodInsn(this.opcode(), this.owner(), this.name(), this.descriptor().descriptorString(), this.isInterface());
        }

        @Override
        public Handle createHandle() {
            return new Handle(this.opcode(), this.owner(), this.name(), this.descriptor().descriptorString(), this.isInterface());
        }
    }

    public static interface Rewrite {
        public void apply(MethodVisitor var1, MethodNode var2);

        public Handle createHandle();
    }
}

