/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.util;

import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.Set;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.commons.Method;

public final class DescriptorUtils {
    public static ClassDesc fromOwner(String owner) {
        return ClassDesc.ofDescriptor("L" + owner + ";");
    }

    public static String toOwner(ClassDesc desc) {
        String descriptor = desc.descriptorString();
        return descriptor.substring(1, descriptor.length() - 1);
    }

    public static ClassDesc desc(Class<?> clazz) {
        return clazz.describeConstable().orElseThrow();
    }

    public static MethodTypeDesc desc(Executable executable) {
        Method asmMethod;
        if (executable instanceof java.lang.reflect.Method) {
            java.lang.reflect.Method method = (java.lang.reflect.Method)executable;
            asmMethod = Method.getMethod((java.lang.reflect.Method)method);
        } else if (executable instanceof Constructor) {
            Constructor constructor = (Constructor)executable;
            asmMethod = Method.getMethod((Constructor)constructor);
        } else {
            throw new IllegalArgumentException(executable + " isn't a constructor or method");
        }
        return MethodTypeDesc.ofDescriptor(asmMethod.getDescriptor());
    }

    public static MethodTypeDesc methodDesc(String descriptor) {
        return MethodTypeDesc.ofDescriptor(descriptor);
    }

    public static ClassDesc classDesc(String descriptor) {
        return ClassDesc.ofDescriptor(descriptor);
    }

    public static MethodTypeDesc replaceParameters(MethodTypeDesc descriptor, Predicate<? super ClassDesc> oldParam, ClassDesc newParam) {
        return DescriptorUtils.replaceParameters(descriptor, oldParam, newParam, null);
    }

    public static MethodTypeDesc replaceParameters(MethodTypeDesc descriptor, Predicate<? super ClassDesc> oldParam, ClassDesc newParam, @Nullable Set<Integer> positionCollector) {
        for (int i = 0; i < descriptor.parameterCount(); ++i) {
            if (!oldParam.test(descriptor.parameterType(i))) continue;
            descriptor = descriptor.changeParameterType(i, newParam);
            if (positionCollector == null) continue;
            positionCollector.add(i);
        }
        return descriptor;
    }

    private DescriptorUtils() {
    }
}

