/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.component;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.returnsreceiver.qual.This;
import org.geysermc.cumulus.component.Component;
import org.geysermc.cumulus.component.impl.StepSliderComponentImpl;

public interface StepSliderComponent
extends Component {
    public static @NonNull StepSliderComponent of(@NonNull String text, @NonNull List<String> steps, @NonNegative int defaultStep) {
        return new StepSliderComponentImpl(text, steps, defaultStep);
    }

    public static @NonNull StepSliderComponent of(@NonNull String text, @NonNegative int defaultStep, String ... steps) {
        return StepSliderComponent.of(text, Arrays.asList(steps), defaultStep);
    }

    public static @NonNull StepSliderComponent of(@NonNull String text, String ... steps) {
        return StepSliderComponent.of(text, 0, steps);
    }

    public static @NonNull Builder builder() {
        return new StepSliderComponentImpl.Builder();
    }

    public static @NonNull Builder builder(@NonNull String text) {
        return StepSliderComponent.builder().text(text);
    }

    public @NonNull List<String> steps();

    public @NonNegative int defaultStep();

    @Deprecated
    public @NonNull List<String> getSteps();

    @Deprecated
    public @NonNegative int getDefaultStep();

    public static interface Builder {
        public @This Builder text(@NonNull String var1);

        public @This Builder step(@NonNull String var1, boolean var2);

        public @This Builder step(@NonNull String var1);

        public @This Builder defaultStep(@NonNegative int var1) throws IllegalArgumentException;

        public @NonNull StepSliderComponent build();

        public @NonNull StepSliderComponent translateAndBuild(@NonNull Function<String, String> var1);
    }
}

