/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.api;

import com.google.inject.Inject;
import java.nio.charset.StandardCharsets;
import org.geysermc.floodgate.api.SimpleFloodgateApi;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.util.BedrockData;

public final class ProxyFloodgateApi
extends SimpleFloodgateApi {
    @Inject
    private FloodgateCipher cipher;

    public byte[] createEncryptedData(BedrockData bedrockData) {
        try {
            return this.cipher.encryptFromString(bedrockData.toString());
        }
        catch (Exception exception) {
            throw new IllegalStateException("We failed to create the encrypted data, but creating encrypted data is mandatory!", exception);
        }
    }

    public String createEncryptedDataString(BedrockData bedrockData) {
        return new String(this.createEncryptedData(bedrockData), StandardCharsets.UTF_8);
    }
}

