/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.inject.velocity;

import com.velocitypowered.api.proxy.ProxyServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.Method;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class VelocityInjector
extends CommonPlatformInjector {
    private final ProxyServer server;
    private boolean injected;

    @Override
    public void inject() {
        if (this.isInjected()) {
            return;
        }
        Object connectionManager = ReflectionUtils.getValue((Object)this.server, "cm");
        Object serverInitializerHolder = ReflectionUtils.getValue(connectionManager, "serverChannelInitializer");
        ChannelInitializer serverInitializer = (ChannelInitializer)ReflectionUtils.castedInvoke(serverInitializerHolder, "get");
        Method serverSetter = ReflectionUtils.getMethod(serverInitializerHolder, "set", ChannelInitializer.class);
        ReflectionUtils.invoke(serverInitializerHolder, serverSetter, new Object[]{new VelocityChannelInitializer(this, serverInitializer, false)});
        Object backendInitializerHolder = ReflectionUtils.getValue(connectionManager, "backendChannelInitializer");
        ChannelInitializer backendInitializer = (ChannelInitializer)ReflectionUtils.castedInvoke(backendInitializerHolder, "get");
        Method backendSetter = ReflectionUtils.getMethod(backendInitializerHolder, "set", ChannelInitializer.class);
        ReflectionUtils.invoke(backendInitializerHolder, backendSetter, new Object[]{new VelocityChannelInitializer(this, backendInitializer, true)});
        this.injected = true;
    }

    @Override
    public boolean canRemoveInjection() {
        return false;
    }

    @Override
    public void removeInjection() {
        throw new IllegalStateException("Floodgate cannot remove itself from Velocity without a reboot");
    }

    public VelocityInjector(ProxyServer server) {
        this.server = server;
    }

    @Override
    public boolean isInjected() {
        return this.injected;
    }

    private static final class VelocityChannelInitializer
    extends ChannelInitializer<Channel> {
        private static final Method initChannel = ReflectionUtils.getMethod(ChannelInitializer.class, "initChannel", Channel.class);
        private final VelocityInjector injector;
        private final ChannelInitializer original;
        private final boolean proxyToServer;

        protected void initChannel(Channel channel) {
            ReflectionUtils.invoke(this.original, initChannel, channel);
            this.injector.injectAddonsCall(channel, this.proxyToServer);
            this.injector.addInjectedClient(channel);
        }

        public VelocityChannelInitializer(VelocityInjector injector, ChannelInitializer original, boolean proxyToServer) {
            this.injector = injector;
            this.original = original;
            this.proxyToServer = proxyToServer;
        }
    }
}

