/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.velocitypowered.api.event.Continuation;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.util.GameProfile;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import org.geysermc.floodgate.api.ProxyFloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.skin.SkinDataImpl;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.MojangUtils;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class VelocityListener {
    private static final Field INITIAL_MINECRAFT_CONNECTION;
    private static final Field INITIAL_CONNECTION_DELEGATE;
    private static final Field CHANNEL;
    private static final GameProfile.Property DEFAULT_TEXTURE_PROPERTY;
    private final Cache<InboundConnection, FloodgatePlayer> playerCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterAccess(20L, TimeUnit.SECONDS).build();
    @Inject
    private ProxyFloodgateConfig config;
    @Inject
    private ProxyFloodgateApi api;
    @Inject
    private LanguageManager languageManager;
    @Inject
    private FloodgateLogger logger;
    @Inject
    @Named(value="playerAttribute")
    private AttributeKey<FloodgatePlayer> playerAttribute;
    @Inject
    @Named(value="kickMessageAttribute")
    private AttributeKey<String> kickMessageAttribute;
    @Inject
    private MojangUtils mojangUtils;

    @Subscribe(order=PostOrder.EARLY)
    public void onPreLogin(PreLoginEvent event) {
        String kickMessage;
        FloodgatePlayer player = null;
        try {
            InboundConnection connection = event.getConnection();
            if (INITIAL_CONNECTION_DELEGATE != null) {
                connection = (InboundConnection)ReflectionUtils.getCastedValue((Object)connection, INITIAL_CONNECTION_DELEGATE);
            }
            Object mcConnection = ReflectionUtils.getValue((Object)connection, INITIAL_MINECRAFT_CONNECTION);
            Channel channel = (Channel)ReflectionUtils.getCastedValue(mcConnection, CHANNEL);
            player = (FloodgatePlayer)channel.attr(this.playerAttribute).get();
            kickMessage = (String)channel.attr(this.kickMessageAttribute).get();
        }
        catch (Exception exception) {
            this.logger.error("Failed get the FloodgatePlayer from the player's channel", exception, new Object[0]);
            kickMessage = "Failed to get the FloodgatePlayer from the players's Channel";
        }
        if (kickMessage != null) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)kickMessage)));
            return;
        }
        if (player != null) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOfflineMode());
            this.playerCache.put((Object)event.getConnection(), (Object)player);
        }
    }

    @Subscribe(order=PostOrder.EARLY)
    public void onGameProfileRequest(GameProfileRequestEvent event, Continuation continuation) {
        FloodgatePlayer player = (FloodgatePlayer)this.playerCache.getIfPresent((Object)event.getConnection());
        if (player == null) {
            continuation.resume();
            return;
        }
        this.playerCache.invalidate((Object)event.getConnection());
        if (!player.isLinked()) {
            event.setGameProfile(new GameProfile(player.getCorrectUniqueId(), player.getCorrectUsername(), List.of(DEFAULT_TEXTURE_PROPERTY)));
            continuation.resume();
            return;
        }
        ((CompletableFuture)this.mojangUtils.skinFor(player.getCorrectUniqueId()).exceptionally(exception -> {
            this.logger.debug("Unexpected skin fetch error for " + String.valueOf(player.getCorrectUniqueId()), exception);
            return SkinDataImpl.DEFAULT_SKIN;
        })).thenAccept(skin -> {
            event.setGameProfile(new GameProfile(player.getCorrectUniqueId(), player.getCorrectUsername(), List.of(new GameProfile.Property("textures", skin.value(), skin.signature()))));
            continuation.resume();
        });
    }

    @Subscribe(order=PostOrder.LAST)
    public void onLogin(LoginEvent event) {
        FloodgatePlayer player;
        if (event.getResult().isAllowed() && (player = this.api.getPlayer(event.getPlayer().getUniqueId())) != null) {
            this.languageManager.loadLocale(player.getLanguageCode());
        }
    }

    @Subscribe(order=PostOrder.LAST)
    public void onDisconnect(DisconnectEvent event) {
        this.api.playerRemoved(event.getPlayer().getUniqueId());
    }

    static {
        Class<?> initialConnection = ReflectionUtils.getPrefixedClass("connection.client.InitialInboundConnection");
        Class<?> minecraftConnection = ReflectionUtils.getPrefixedClass("connection.MinecraftConnection");
        INITIAL_MINECRAFT_CONNECTION = ReflectionUtils.getFieldOfType(initialConnection, minecraftConnection);
        Class<?> loginInboundConnection = ReflectionUtils.getPrefixedClassSilently("connection.client.LoginInboundConnection");
        if (loginInboundConnection != null) {
            INITIAL_CONNECTION_DELEGATE = ReflectionUtils.getField(loginInboundConnection, "delegate");
            Objects.requireNonNull(INITIAL_CONNECTION_DELEGATE, "initial inbound connection delegate cannot be null");
        } else {
            INITIAL_CONNECTION_DELEGATE = null;
        }
        CHANNEL = ReflectionUtils.getFieldOfType(minecraftConnection, Channel.class);
        DEFAULT_TEXTURE_PROPERTY = new GameProfile.Property("textures", "ewogICJ0aW1lc3RhbXAiIDogMTcxNTcxNzM1NTI2MywKICAicHJvZmlsZUlkIiA6ICIyMWUzNjdkNzI1Y2Y0ZTNiYjI2OTJjNGEzMDBhNGRlYiIsCiAgInByb2ZpbGVOYW1lIiA6ICJHZXlzZXJNQyIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS8zMWY0NzdlYjFhN2JlZWU2MzFjMmNhNjRkMDZmOGY2OGZhOTNhMzM4NmQwNDQ1MmFiMjdmNDNhY2RmMWI2MGNiIgogICAgfQogIH0KfQ", "dFKIZ5d6vNqCSe1IFGiVLjt3cnW8qh4qNP2umg9zqkX9bvAQawuR1iuO1kCD/+ye8A6GQFv2wRCdxdrjp5+Vrr0SsWqMnsYDN8cEg6CD18mAnaKI1TYDuGbdJaqLyGqN5wqSMdHxchs9iovFkde5ir4aYdvHkA11vOTi11L4kUzETGzJ4iKVuZOv4dq+B7wFAWqp4n8QZfhixyvemFazQHlLmxnuhU+jhpZMvYY9MAaRAJonfy/wJe9LymbTe0EJ8N+NwZQDrEUzgfBFo4OIGDqRZwvydInCqkjhPMtHCSL25VOKwcFocYpRYbk4eIKM4CLjYlBiQGki+XKsPaljwjVhnT0jUupSf7yraGb3T0CsVBjhDbIIIp9nytlbO0GvxHu0TzYjkr4Iji0do5jlCKQ/OasXcL21wd6ozw0t1QZnnzxi9ewSuyYVY9ErmWdkww1OtCIgJilceEBwNAB8+mhJ062WFaYPgJQAmOREM8InW33dbbeENMFhQi4LIO5P7p9ye3B4Lrwm20xtd9wJk3lewzcs8ezh0LUF6jPSDQDivgSKU49mLCTmOi+WZh8zKjjxfVEtNZON2W+3nct0LiWBVsQ55HzlvF0FFxuRVm6pxi6MQK2ernv3DQl0hUqyQ1+RV9nfZXTQOAUzwLjKx3t2zKqyZIiNEKLE+iAXrsE=");
    }
}

