/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.org.incendo.cloud.velocity.parser;

import com.mojang.brigadier.Message;
import com.velocitypowered.api.command.VelocityBrigadierMessage;
import com.velocitypowered.api.proxy.Player;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.shadow.org.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import org.geysermc.floodgate.shadow.org.incendo.cloud.caption.CaptionVariable;
import org.geysermc.floodgate.shadow.org.incendo.cloud.component.CommandComponent;
import org.geysermc.floodgate.shadow.org.incendo.cloud.context.CommandContext;
import org.geysermc.floodgate.shadow.org.incendo.cloud.context.CommandInput;
import org.geysermc.floodgate.shadow.org.incendo.cloud.exception.parsing.ParserException;
import org.geysermc.floodgate.shadow.org.incendo.cloud.parser.ArgumentParseResult;
import org.geysermc.floodgate.shadow.org.incendo.cloud.parser.ArgumentParser;
import org.geysermc.floodgate.shadow.org.incendo.cloud.parser.ParserDescriptor;
import org.geysermc.floodgate.shadow.org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.geysermc.floodgate.shadow.org.incendo.cloud.suggestion.Suggestion;
import org.geysermc.floodgate.shadow.org.incendo.cloud.velocity.VelocityCaptionKeys;
import org.geysermc.floodgate.shadow.org.incendo.cloud.velocity.VelocityContextKeys;

public final class PlayerParser<C>
implements ArgumentParser<C, Player>,
BlockingSuggestionProvider<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Player> playerParser() {
        return ParserDescriptor.of(new PlayerParser<C>(), Player.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, Player> playerComponent() {
        return CommandComponent.builder().parser(PlayerParser.playerParser());
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull Player> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        Player player = commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getPlayer(input).orElse(null);
        if (player == null) {
            return ArgumentParseResult.failure(new PlayerParseException(input, commandContext));
        }
        return ArgumentParseResult.success(player);
    }

    @Override
    public @NonNull Iterable<? extends @NonNull Suggestion> suggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getAllPlayers().stream().map(player -> TooltipSuggestion.suggestion(player.getUsername(), (Message)VelocityBrigadierMessage.tooltip((Component)Component.text((String)player.getUniqueId().toString())))).collect(Collectors.toList());
    }

    public static final class PlayerParseException
    extends ParserException {
        private PlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(PlayerParser.class, context, VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, CaptionVariable.of("input", input));
        }
    }
}

