/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.org.incendo.cloud.velocity.parser;

import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.shadow.org.incendo.cloud.caption.CaptionVariable;
import org.geysermc.floodgate.shadow.org.incendo.cloud.component.CommandComponent;
import org.geysermc.floodgate.shadow.org.incendo.cloud.context.CommandContext;
import org.geysermc.floodgate.shadow.org.incendo.cloud.context.CommandInput;
import org.geysermc.floodgate.shadow.org.incendo.cloud.exception.parsing.ParserException;
import org.geysermc.floodgate.shadow.org.incendo.cloud.parser.ArgumentParseResult;
import org.geysermc.floodgate.shadow.org.incendo.cloud.parser.ArgumentParser;
import org.geysermc.floodgate.shadow.org.incendo.cloud.parser.ParserDescriptor;
import org.geysermc.floodgate.shadow.org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.geysermc.floodgate.shadow.org.incendo.cloud.velocity.VelocityCaptionKeys;
import org.geysermc.floodgate.shadow.org.incendo.cloud.velocity.VelocityContextKeys;

public final class ServerParser<C>
implements ArgumentParser<C, RegisteredServer>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, RegisteredServer> serverParser() {
        return ParserDescriptor.of(new ServerParser<C>(), RegisteredServer.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, RegisteredServer> serverComponent() {
        return CommandComponent.builder().parser(ServerParser.serverParser());
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull RegisteredServer> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        RegisteredServer server = commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getServer(input).orElse(null);
        if (server == null) {
            return ArgumentParseResult.failure(new ServerParseException(input, commandContext));
        }
        return ArgumentParseResult.success(server);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getAllServers().stream().map(s2 -> s2.getServerInfo().getName()).collect(Collectors.toList());
    }

    public static final class ServerParseException
    extends ParserException {
        private ServerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(ServerParser.class, context, VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_SERVER, CaptionVariable.of("input", input));
        }
    }
}

