/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.util.GameProfile;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.event.EventBus;
import org.geysermc.floodgate.event.skin.SkinApplyEventImpl;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.skin.SkinDataImpl;

@Singleton
public class VelocitySkinApplier
implements SkinApplier {
    @Inject
    private ProxyServer server;
    @Inject
    private EventBus eventBus;

    @Override
    public void applySkin(@NonNull FloodgatePlayer floodgatePlayer,  @NonNull SkinApplyEvent.SkinData skinData, boolean internal) {
        this.server.getPlayer(floodgatePlayer.getCorrectUniqueId()).ifPresent(player -> {
            ArrayList<GameProfile.Property> properties = new ArrayList<GameProfile.Property>(player.getGameProfileProperties());
            SkinApplyEvent.SkinData currentSkin = this.currentSkin(properties);
            SkinApplyEventImpl event = new SkinApplyEventImpl(floodgatePlayer, currentSkin, skinData);
            event.setCancelled(!internal && floodgatePlayer.isLinked());
            this.eventBus.fire(event);
            if (event.isCancelled()) {
                return;
            }
            this.replaceSkin(properties, event.newSkin());
            player.setGameProfileProperties(properties);
        });
    }

    private SkinApplyEvent.SkinData currentSkin(List<GameProfile.Property> properties) {
        for (GameProfile.Property property : properties) {
            if (!property.getName().equals("textures") || property.getValue().isEmpty()) continue;
            return new SkinDataImpl(property.getValue(), property.getSignature());
        }
        return null;
    }

    private void replaceSkin(List<GameProfile.Property> properties, SkinApplyEvent.SkinData skinData) {
        properties.removeIf(property -> property.getName().equals("textures"));
        properties.add(new GameProfile.Property("textures", skinData.value(), skinData.signature()));
    }
}

