/*
 * Decompiled with CFR 0.152.
 */
package org.lanternpowered.lmbda;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class InternalUtilities {
    private static final @NonNull List<@NonNull Class<?>> javaTypeSubclasses = Arrays.asList(Class.class, ParameterizedType.class, GenericArrayType.class, WildcardType.class, TypeVariable.class);

    InternalUtilities() {
    }

    static @NonNull String getTypeClassName(@NonNull Type type) {
        return javaTypeSubclasses.stream().filter(subclass -> subclass.isInstance(type)).map(Class::getSimpleName).findFirst().orElseGet(() -> type.getClass().getName());
    }

    static @NonNull String getPackageName(@NonNull Class<?> theClass) {
        Class<?> target = theClass;
        while (target.isArray()) {
            target = target.getComponentType();
        }
        if (target.isPrimitive()) {
            return "java.lang";
        }
        return InternalUtilities.getPackageName(target.getName());
    }

    static @NonNull String getPackageName(@NonNull String className) {
        int index = className.lastIndexOf(46);
        return index == -1 ? "" : className.substring(0, index);
    }

    static <T> T doUnchecked(@NonNull ThrowableSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            throw InternalUtilities.throwUnchecked(t);
        }
    }

    static @NonNull RuntimeException throwUnchecked(@NonNull Throwable t) {
        InternalUtilities.throwUnchecked0(t);
        throw new AssertionError((Object)"Unreachable.");
    }

    private static <T extends Throwable> void throwUnchecked0(@NonNull Throwable t) throws T {
        throw t;
    }

    @FunctionalInterface
    static interface ThrowableSupplier<@Nullable T> {
        public T get() throws Throwable;
    }
}

