/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.natives;

import com.nukkitx.natives.Native;
import java.nio.ByteBuffer;
import java.security.DigestException;

public interface NativeDigest
extends Native {
    default public void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    public void update(byte[] var1, int var2, int var3);

    public void update(ByteBuffer var1);

    public byte[] digest();

    default public int digest(byte[] input, int offset, int len) throws DigestException {
        if (input == null) {
            throw new IllegalArgumentException("No output buffer given");
        }
        if (input.length - offset < len) {
            throw new IllegalArgumentException("Output buffer too small for specified offset and length");
        }
        byte[] digest = this.digest();
        if (len < digest.length) {
            throw new DigestException("partial digests not returned");
        }
        if (input.length - offset < digest.length) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(digest, 0, input, offset, digest.length);
        return digest.length;
    }

    default public void digest(ByteBuffer buffer) {
        buffer.put(this.digest());
    }

    public void reset();
}

