/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.bedrock.model;

import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.raphimc.minecraftauth.util.Expirable;
import net.raphimc.minecraftauth.util.jwt.Jwt;

public final class MinecraftMultiplayerToken
implements Expirable {
    private final long expireTimeMs;
    private final String token;
    private final AtomicReference<Object> parsedToken = new AtomicReference();

    public static MinecraftMultiplayerToken fromJson(JsonObject json) {
        return MinecraftMultiplayerToken.fromJson(new GsonObject(json));
    }

    public static MinecraftMultiplayerToken fromJson(GsonObject json) {
        return new MinecraftMultiplayerToken(json.reqLong("expireTimeMs"), json.reqString("token"));
    }

    public static JsonObject toJson(MinecraftMultiplayerToken multiplayerToken) {
        JsonObject json = new JsonObject();
        json.addProperty("_saveVersion", (Number)1);
        json.addProperty("expireTimeMs", (Number)multiplayerToken.expireTimeMs);
        json.addProperty("token", multiplayerToken.token);
        return json;
    }

    public String getDisplayName() {
        return this.getParsedToken().getPayload().reqString("xname");
    }

    public String getXuid() {
        return this.getParsedToken().getPayload().reqString("xid");
    }

    public UUID getUuid() {
        return UUID.nameUUIDFromBytes(("pocket-auth-1-xuid:" + this.getXuid()).getBytes(StandardCharsets.UTF_8));
    }

    @Generated
    public MinecraftMultiplayerToken(long expireTimeMs, String token) {
        this.expireTimeMs = expireTimeMs;
        this.token = token;
    }

    @Override
    @Generated
    public long getExpireTimeMs() {
        return this.expireTimeMs;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinecraftMultiplayerToken)) {
            return false;
        }
        MinecraftMultiplayerToken other = (MinecraftMultiplayerToken)o;
        if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expireTimeMs = this.getExpireTimeMs();
        result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MinecraftMultiplayerToken(expireTimeMs=" + this.getExpireTimeMs() + ", token=" + this.getToken() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Jwt getParsedToken() {
        Object $value = this.parsedToken.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.parsedToken;
            synchronized (atomicReference) {
                $value = this.parsedToken.get();
                if ($value == null) {
                    Jwt actualValue = Jwt.parse(this.token);
                    $value = actualValue == null ? this.parsedToken : actualValue;
                    this.parsedToken.set($value);
                }
            }
        }
        return (Jwt)($value == this.parsedToken ? null : $value);
    }
}

