/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.imaginary;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.imaginary.Complexd;

@ParametersAreNonnullByDefault
public class ImmutableComplexd
extends Complexd {
    private static final long serialVersionUID = 1L;
    private final double x;
    private final double y;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableComplexd(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    @Nonnull
    public Complexd add(double x, double y) {
        return Complexd.from(this.x + x, this.y + y);
    }

    @Override
    @Nonnull
    public Complexd sub(double x, double y) {
        return Complexd.from(this.x - x, this.y - y);
    }

    @Override
    @Nonnull
    public Complexd mul(double a) {
        return Complexd.from(this.x * a, this.y * a);
    }

    @Override
    @Nonnull
    public Complexd mul(double x, double y) {
        return Complexd.from(this.x * x - this.y * y, this.x * y + this.y * x);
    }

    @Override
    @Nonnull
    public Complexd div(double a) {
        return Complexd.from(this.x / a, this.y / a);
    }

    @Override
    @Nonnull
    public Complexd div(double x, double y) {
        double d = x * x + y * y;
        return Complexd.from((this.x * x + this.y * y) / d, (this.y * x - this.x * y) / d);
    }

    @Override
    public double dot(Complexd c) {
        return this.dot(c.getX(), c.getY());
    }

    @Override
    public double dot(float x, float y) {
        return this.dot((double)x, (double)y);
    }

    @Override
    public double dot(double x, double y) {
        return this.x * x + this.y * y;
    }

    @Override
    @Nonnull
    public Complexd conjugate() {
        return Complexd.from(this.x, -this.y);
    }

    @Override
    @Nonnull
    public Complexd invert() {
        double lengthSquared = this.lengthSquared();
        if (Math.abs(lengthSquared) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot invert a complex of length zero");
        }
        return this.conjugate().div(lengthSquared);
    }

    @Override
    @Nonnull
    public Complexd normalize() {
        double length = this.length();
        if (Math.abs(length) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero complex");
        }
        return Complexd.from(this.x / length, this.y / length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Complexd)) {
            return false;
        }
        Complexd complex = (Complexd)o;
        if (Double.compare(complex.getX(), this.x) != 0) {
            return false;
        }
        return Double.compare(complex.getY(), this.y) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0 ? Double.hashCode(this.x) : 0;
            this.hashCode = 31 * result + (this.y != 0.0 ? Double.hashCode(this.y) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

