/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.camera;

import java.util.List;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.camera.CameraSplineType;

public class CameraSplineInstruction {
    private float totalTime;
    private CameraSplineType type;
    private List<Vector3f> curve;
    private List<Vector2f> progressKeyFrames;
    private List<SplineRotationOption> rotationOption;

    public float getTotalTime() {
        return this.totalTime;
    }

    public CameraSplineType getType() {
        return this.type;
    }

    public List<Vector3f> getCurve() {
        return this.curve;
    }

    public List<Vector2f> getProgressKeyFrames() {
        return this.progressKeyFrames;
    }

    public List<SplineRotationOption> getRotationOption() {
        return this.rotationOption;
    }

    public void setTotalTime(float totalTime) {
        this.totalTime = totalTime;
    }

    public void setType(CameraSplineType type) {
        this.type = type;
    }

    public void setCurve(List<Vector3f> curve) {
        this.curve = curve;
    }

    public void setProgressKeyFrames(List<Vector2f> progressKeyFrames) {
        this.progressKeyFrames = progressKeyFrames;
    }

    public void setRotationOption(List<SplineRotationOption> rotationOption) {
        this.rotationOption = rotationOption;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CameraSplineInstruction)) {
            return false;
        }
        CameraSplineInstruction other = (CameraSplineInstruction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getTotalTime(), other.getTotalTime()) != 0) {
            return false;
        }
        CameraSplineType this$type = this.getType();
        CameraSplineType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<Vector3f> this$curve = this.getCurve();
        List<Vector3f> other$curve = other.getCurve();
        if (this$curve == null ? other$curve != null : !((Object)this$curve).equals(other$curve)) {
            return false;
        }
        List<Vector2f> this$progressKeyFrames = this.getProgressKeyFrames();
        List<Vector2f> other$progressKeyFrames = other.getProgressKeyFrames();
        if (this$progressKeyFrames == null ? other$progressKeyFrames != null : !((Object)this$progressKeyFrames).equals(other$progressKeyFrames)) {
            return false;
        }
        List<SplineRotationOption> this$rotationOption = this.getRotationOption();
        List<SplineRotationOption> other$rotationOption = other.getRotationOption();
        return !(this$rotationOption == null ? other$rotationOption != null : !((Object)this$rotationOption).equals(other$rotationOption));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CameraSplineInstruction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getTotalTime());
        CameraSplineType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<Vector3f> $curve = this.getCurve();
        result = result * 59 + ($curve == null ? 43 : ((Object)$curve).hashCode());
        List<Vector2f> $progressKeyFrames = this.getProgressKeyFrames();
        result = result * 59 + ($progressKeyFrames == null ? 43 : ((Object)$progressKeyFrames).hashCode());
        List<SplineRotationOption> $rotationOption = this.getRotationOption();
        result = result * 59 + ($rotationOption == null ? 43 : ((Object)$rotationOption).hashCode());
        return result;
    }

    public String toString() {
        return "CameraSplineInstruction(totalTime=" + this.getTotalTime() + ", type=" + (Object)((Object)this.getType()) + ", curve=" + this.getCurve() + ", progressKeyFrames=" + this.getProgressKeyFrames() + ", rotationOption=" + this.getRotationOption() + ")";
    }

    public CameraSplineInstruction(float totalTime, CameraSplineType type, List<Vector3f> curve, List<Vector2f> progressKeyFrames, List<SplineRotationOption> rotationOption) {
        this.totalTime = totalTime;
        this.type = type;
        this.curve = curve;
        this.progressKeyFrames = progressKeyFrames;
        this.rotationOption = rotationOption;
    }

    public static class SplineRotationOption {
        private Vector3f keyFrameValues;
        private float keyFrameTimes;

        public Vector3f getKeyFrameValues() {
            return this.keyFrameValues;
        }

        public float getKeyFrameTimes() {
            return this.keyFrameTimes;
        }

        public void setKeyFrameValues(Vector3f keyFrameValues) {
            this.keyFrameValues = keyFrameValues;
        }

        public void setKeyFrameTimes(float keyFrameTimes) {
            this.keyFrameTimes = keyFrameTimes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SplineRotationOption)) {
                return false;
            }
            SplineRotationOption other = (SplineRotationOption)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getKeyFrameTimes(), other.getKeyFrameTimes()) != 0) {
                return false;
            }
            Vector3f this$keyFrameValues = this.getKeyFrameValues();
            Vector3f other$keyFrameValues = other.getKeyFrameValues();
            return !(this$keyFrameValues == null ? other$keyFrameValues != null : !this$keyFrameValues.equals(other$keyFrameValues));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SplineRotationOption;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getKeyFrameTimes());
            Vector3f $keyFrameValues = this.getKeyFrameValues();
            result = result * 59 + ($keyFrameValues == null ? 43 : $keyFrameValues.hashCode());
            return result;
        }

        public String toString() {
            return "CameraSplineInstruction.SplineRotationOption(keyFrameValues=" + this.getKeyFrameValues() + ", keyFrameTimes=" + this.getKeyFrameTimes() + ")";
        }

        public SplineRotationOption(Vector3f keyFrameValues, float keyFrameTimes) {
            this.keyFrameValues = keyFrameValues;
            this.keyFrameTimes = keyFrameTimes;
        }
    }
}

