/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.dump;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.util.DeviceOs;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.util.MinecraftVersion;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.pack.ResourcePackHolder;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.geysermc.geyser.platform.velocity.shaded.org.spongepowered.configurate.CommentedConfigurationNode;
import org.geysermc.geyser.platform.velocity.shaded.org.spongepowered.configurate.ConfigurationNode;
import org.geysermc.geyser.platform.velocity.shaded.org.spongepowered.configurate.ConfigurationOptions;
import org.geysermc.geyser.platform.velocity.shaded.org.spongepowered.configurate.interfaces.InterfaceDefaultOptions;
import org.geysermc.geyser.platform.velocity.shaded.org.spongepowered.configurate.serialize.SerializationException;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.AsteriskSerializer;
import org.geysermc.geyser.util.CpuUtils;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.WebUtils;

public class DumpInfo {
    private static final long MEGABYTE = 0x100000L;
    private final VersionInfo versionInfo;
    private final int cpuCount;
    private final String cpuName;
    private final Locale systemLocale;
    private final String systemEncoding;
    private final GitInfo gitInfo;
    private Object config;
    private final Object2IntMap<DeviceOs> userPlatforms;
    private final int connectionAttempts;
    private final String hash;
    private final RamInfo ramInfo;
    private LogsInfo logsInfo;
    private final BootstrapDumpInfo bootstrapInfo;
    private final FlagsInfo flagsInfo;
    private final List<ExtensionInfo> extensionInfo;
    private final List<PackInfo> packInfo;
    private final MappingInfo mappingInfo;

    public DumpInfo(GeyserImpl geyser, boolean addLog) {
        String sha256Hash;
        block8: {
            block7: {
                this.versionInfo = new VersionInfo();
                this.cpuCount = Runtime.getRuntime().availableProcessors();
                this.cpuName = CpuUtils.tryGetProcessorName();
                this.systemLocale = Locale.getDefault();
                this.systemEncoding = Charset.defaultCharset().displayName();
                this.gitInfo = new GitInfo("1045", "ad147e212357ddcf933a5b43d9256106a995cdc0".substring(0, 7), "ad147e212357ddcf933a5b43d9256106a995cdc0", "master", "https://github.com/GeyserMC/Geyser");
                try {
                    ConfigurationOptions options = InterfaceDefaultOptions.addTo(ConfigurationOptions.defaults(), builder -> builder.addProcessor(AsteriskSerializer.Asterisk.class, String.class, AsteriskSerializer.CONFIGURATE_SERIALIZER)).shouldCopyDefaults(false);
                    CommentedConfigurationNode configNode = CommentedConfigurationNode.root(options);
                    configNode.set(geyser.config());
                    this.config = this.toGson(configNode);
                }
                catch (SerializationException e) {
                    e.printStackTrace();
                    if (!geyser.config().debugMode()) break block7;
                    e.printStackTrace();
                }
            }
            sha256Hash = "unknown";
            try {
                File file = new File(DumpInfo.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                ByteSource byteSource = com.google.common.io.Files.asByteSource((File)file);
                sha256Hash = byteSource.hash(Hashing.sha256()).toString();
            }
            catch (Exception e) {
                if (!geyser.config().debugMode()) break block8;
                e.printStackTrace();
            }
        }
        this.hash = sha256Hash;
        this.ramInfo = new RamInfo();
        if (addLog) {
            this.logsInfo = new LogsInfo(geyser);
        }
        this.userPlatforms = new Object2IntOpenHashMap<DeviceOs>();
        for (GeyserSession session : geyser.getSessionManager().getAllSessions()) {
            DeviceOs device = session.getClientData().getDeviceOs();
            this.userPlatforms.put(device, this.userPlatforms.getOrDefault((Object)device, 0) + 1);
        }
        this.connectionAttempts = geyser.getGeyserServer() != null ? geyser.getGeyserServer().getConnectionAttempts() : 0;
        this.bootstrapInfo = geyser.getBootstrap().getDumpInfo();
        this.flagsInfo = new FlagsInfo();
        this.extensionInfo = new ArrayList<ExtensionInfo>();
        for (Extension extension : GeyserApi.api().extensionManager().extensions()) {
            this.extensionInfo.add(new ExtensionInfo(extension.isEnabled(), extension.name(), extension.description().version(), extension.description().apiVersion(), extension.description().main(), extension.description().authors()));
        }
        this.packInfo = ((Map)Registries.RESOURCE_PACKS.get()).values().stream().map(PackInfo::new).toList();
        this.mappingInfo = new MappingInfo(((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length, ((Map)BlockRegistries.CUSTOM_SKULLS.get()).size(), Registries.ITEMS.forVersion(GameProtocol.DEFAULT_BEDROCK_PROTOCOL).getCustomIdMappings().size());
    }

    private JsonElement toGson(ConfigurationNode node) {
        if (node.isMap()) {
            JsonObject object = new JsonObject();
            node.childrenMap().forEach((key, value) -> {
                JsonElement json = this.toGson((ConfigurationNode)value);
                object.add(key.toString(), json);
            });
            return object;
        }
        if (node.isList()) {
            JsonArray array = new JsonArray();
            node.childrenList().forEach(childNode -> array.add(this.toGson((ConfigurationNode)childNode)));
            return array;
        }
        return this.convertRawScalar(node);
    }

    private JsonElement convertRawScalar(ConfigurationNode node) {
        @Nullable Object value = node.rawScalar();
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return new JsonPrimitive(n);
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return new JsonPrimitive(b);
        }
        return new JsonPrimitive(value.toString());
    }

    @Generated
    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @Generated
    public int getCpuCount() {
        return this.cpuCount;
    }

    @Generated
    public String getCpuName() {
        return this.cpuName;
    }

    @Generated
    public Locale getSystemLocale() {
        return this.systemLocale;
    }

    @Generated
    public String getSystemEncoding() {
        return this.systemEncoding;
    }

    @Generated
    public GitInfo getGitInfo() {
        return this.gitInfo;
    }

    @Generated
    public Object getConfig() {
        return this.config;
    }

    @Generated
    public Object2IntMap<DeviceOs> getUserPlatforms() {
        return this.userPlatforms;
    }

    @Generated
    public int getConnectionAttempts() {
        return this.connectionAttempts;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public RamInfo getRamInfo() {
        return this.ramInfo;
    }

    @Generated
    public LogsInfo getLogsInfo() {
        return this.logsInfo;
    }

    @Generated
    public BootstrapDumpInfo getBootstrapInfo() {
        return this.bootstrapInfo;
    }

    @Generated
    public FlagsInfo getFlagsInfo() {
        return this.flagsInfo;
    }

    @Generated
    public List<ExtensionInfo> getExtensionInfo() {
        return this.extensionInfo;
    }

    @Generated
    public List<PackInfo> getPackInfo() {
        return this.packInfo;
    }

    @Generated
    public MappingInfo getMappingInfo() {
        return this.mappingInfo;
    }

    public static class VersionInfo {
        private final String name;
        private final String version;
        private final String javaName = System.getProperty("java.vm.name");
        private final String javaVendor = System.getProperty("java.vendor");
        private final String javaVersion = ManagementFactory.getRuntimeMXBean().getVmVersion();
        private final String architecture = System.getProperty("os.arch");
        private final String operatingSystem = System.getProperty("os.name");
        private final String operatingSystemVersion = System.getProperty("os.version");
        private final NetworkInfo network = new NetworkInfo();
        private final MCInfo mcInfo = new MCInfo();

        VersionInfo() {
            this.name = "Geyser";
            this.version = "2.9.2-b1045 (git-master-ad147e2)";
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getJavaName() {
            return this.javaName;
        }

        @Generated
        public String getJavaVendor() {
            return this.javaVendor;
        }

        @Generated
        public String getJavaVersion() {
            return this.javaVersion;
        }

        @Generated
        public String getArchitecture() {
            return this.architecture;
        }

        @Generated
        public String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Generated
        public String getOperatingSystemVersion() {
            return this.operatingSystemVersion;
        }

        @Generated
        public NetworkInfo getNetwork() {
            return this.network;
        }

        @Generated
        public MCInfo getMcInfo() {
            return this.mcInfo;
        }
    }

    public record GitInfo(String buildNumber, @SerializedName(value="git.commit.id.abbrev") String commitHashAbbrev, @SerializedName(value="git.commit.id") String commitHash, @SerializedName(value="git.branch") String branchName, @SerializedName(value="git.remote.origin.url") String originUrl) {
    }

    public record RamInfo(long free, long total, long max) {
        public RamInfo() {
            this(Runtime.getRuntime().freeMemory() / 0x100000L, Runtime.getRuntime().totalMemory() / 0x100000L, Runtime.getRuntime().maxMemory() / 0x100000L);
        }
    }

    public static class LogsInfo {
        private String link;

        public LogsInfo(GeyserImpl geyser) {
            try {
                HashMap<String, String> fields = new HashMap<String, String>();
                fields.put("content", FileUtils.readAllLines(geyser.getBootstrap().getLogsPath()).collect(Collectors.joining("\n")));
                JsonObject logData = new JsonParser().parse(WebUtils.postForm("https://api.mclo.gs/1/log", fields)).getAsJsonObject();
                this.link = logData.get("url").getAsString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Generated
        public String getLink() {
            return this.link;
        }
    }

    public record FlagsInfo(List<String> flags) {
        public FlagsInfo() {
            this(ManagementFactory.getRuntimeMXBean().getInputArguments());
        }
    }

    public record ExtensionInfo(boolean enabled, String name, String version, String apiVersion, String main, List<String> authors) {
    }

    public record MappingInfo(int customBlocks, int customSkulls, int customItems) {
    }

    public record PackInfo(String name, String type, String size) {
        public PackInfo(ResourcePackHolder holder) {
            this(holder.pack().manifest().header().name(), holder.codec().getClass().getSimpleName(), String.format("%.2f MB", Float.valueOf((float)holder.codec().size() / 1000000.0f)));
        }
    }

    public static class MCInfo {
        private final List<String> bedrockVersions = GameProtocol.SUPPORTED_BEDROCK_VERSIONS.stream().map(MinecraftVersion::versionString).toList();
        private final List<Integer> bedrockProtocols = GameProtocol.SUPPORTED_BEDROCK_PROTOCOLS;
        private final int defaultBedrockProtocol = GameProtocol.DEFAULT_BEDROCK_PROTOCOL;
        private final List<String> javaVersions = GameProtocol.getJavaVersions();
        private final int javaProtocol = GameProtocol.getJavaProtocolVersion();

        MCInfo() {
        }

        @Generated
        public List<String> getBedrockVersions() {
            return this.bedrockVersions;
        }

        @Generated
        public List<Integer> getBedrockProtocols() {
            return this.bedrockProtocols;
        }

        @Generated
        public int getDefaultBedrockProtocol() {
            return this.defaultBedrockProtocol;
        }

        @Generated
        public List<String> getJavaVersions() {
            return this.javaVersions;
        }

        @Generated
        public int getJavaProtocol() {
            return this.javaProtocol;
        }
    }

    public static class NetworkInfo {
        private final boolean dockerCheck;
        private String internalIP;

        NetworkInfo() {
            if (AsteriskSerializer.showSensitive) {
                try (Socket socket = new Socket();){
                    socket.connect(new InetSocketAddress("geysermc.org", 80));
                    this.internalIP = socket.getLocalAddress().getHostAddress();
                }
                catch (IOException e1) {
                    try {
                        this.internalIP = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
            } else {
                this.internalIP = "***";
            }
            this.dockerCheck = this.checkDockerBasic();
        }

        private boolean checkDockerBasic() {
            try {
                String output;
                String OS = System.getProperty("os.name").toLowerCase();
                if ((OS.contains("nix") || OS.contains("nux") || OS.indexOf("aix") > 0) && (output = new String(Files.readAllBytes(Paths.get("/proc/1/cgroup", new String[0])))).contains("docker")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        @Generated
        public boolean isDockerCheck() {
            return this.dockerCheck;
        }

        @Generated
        public String getInternalIP() {
            return this.internalIP;
        }
    }
}

