/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;

public class DisplayBaseEntity
extends Entity {
    private @NonNull Vector3f baseTranslation = Vector3f.ZERO;

    public DisplayBaseEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    public void setDisplayNameVisible(BooleanEntityMetadata entityMetadata) {
    }

    @Override
    public void setDisplayName(EntityMetadata<Optional<Component>, ?> entityMetadata) {
    }

    public void setTranslation(EntityMetadata<Vector3f, ?> translationMeta) {
        Vector3f oldTranslation = this.baseTranslation;
        Vector3f vector3f = this.baseTranslation = translationMeta.getValue() == null ? Vector3f.ZERO : translationMeta.getValue();
        if (Objects.equals(oldTranslation, this.baseTranslation)) {
            return;
        }
        if (Vector3f.ZERO.equals(this.baseTranslation)) {
            if (this.vehicle == null) {
                this.setRiderSeatPosition(this.baseTranslation);
                this.moveRelativeRaw(-oldTranslation.getX(), -oldTranslation.getY(), -oldTranslation.getZ(), this.yaw, this.pitch, this.headYaw, false);
            } else {
                EntityUtils.updateMountOffset(this, this.vehicle, true, true, 0, 1);
                this.updateBedrockMetadata();
            }
            return;
        }
        float xTranslation = oldTranslation.getX() - this.baseTranslation.getX();
        float yTranslation = oldTranslation.getY() - this.baseTranslation.getY();
        float zTranslation = oldTranslation.getZ() - this.baseTranslation.getZ();
        if (this.vehicle == null) {
            this.setRiderSeatPosition(this.baseTranslation);
            this.moveRelativeRaw(xTranslation, yTranslation, zTranslation, this.yaw, this.pitch, this.headYaw, false);
        } else {
            EntityUtils.updateMountOffset(this, this.vehicle, true, true, 0, 1);
            this.updateBedrockMetadata();
        }
    }

    public Vector3f getTranslation() {
        return this.baseTranslation;
    }
}

