/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityDataPacket;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;

public class TNTEntity
extends Entity
implements Tickable {
    private int currentTick;

    public TNTEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    public void moveAbsoluteRaw(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        super.moveAbsoluteRaw(position.up(this.definition.offset()), yaw, pitch, headYaw, isOnGround, teleported);
    }

    public void setFuseLength(IntEntityMetadata entityMetadata) {
        this.currentTick = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.IGNITED, true);
        this.dirtyMetadata.put(EntityDataTypes.FUSE_TIME, this.currentTick);
    }

    @Override
    public void tick() {
        if (this.currentTick == 0) {
            return;
        }
        if (this.currentTick % 5 == 0) {
            this.dirtyMetadata.put(EntityDataTypes.FUSE_TIME, this.currentTick);
            SetEntityDataPacket packet = new SetEntityDataPacket();
            packet.setRuntimeEntityId(this.geyserId);
            packet.getMetadata().put(EntityDataTypes.FUSE_TIME, (Object)this.currentTick);
            this.session.sendUpstreamPacket(packet);
        }
        --this.currentTick;
    }
}

