/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.OptionalInt;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.entity.type.living.animal.VariantIntHolder;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;

public class FrogEntity
extends AnimalEntity
implements VariantIntHolder {
    public FrogEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    public void setPose(Pose pose) {
        this.setFlag(EntityFlag.JUMP_GOAL_JUMP, pose == Pose.LONG_JUMPING);
        this.setFlag(EntityFlag.CROAKING, pose == Pose.CROAKING);
        this.setFlag(EntityFlag.EAT_MOB, pose == Pose.USING_TONGUE);
        super.setPose(pose);
    }

    @Override
    public JavaRegistryKey<BuiltInVariant> variantRegistry() {
        return JavaRegistries.FROG_VARIANT;
    }

    @Override
    public void setBedrockVariantId(int bedrockId) {
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, bedrockId);
    }

    public void setTongueTarget(ObjectEntityMetadata<OptionalInt> entityMetadata) {
        OptionalInt entityId = entityMetadata.getValue();
        if (entityId.isPresent()) {
            Entity entity = this.session.getEntityCache().getEntityByJavaId(entityId.getAsInt());
            if (entity != null) {
                this.dirtyMetadata.put(EntityDataTypes.TARGET_EID, entity.geyserId());
            }
        } else {
            this.dirtyMetadata.put(EntityDataTypes.TARGET_EID, 0L);
        }
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.FROG_FOOD;
    }

    public static enum BuiltInVariant implements VariantIntHolder.BuiltIn
    {
        TEMPERATE,
        COLD,
        WARM;

    }
}

