/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.horse;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.animal.horse.AbstractHorseEntity;
import org.geysermc.geyser.entity.vehicle.CamelVehicleComponent;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.Attribute;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.LongEntityMetadata;

public class CamelEntity
extends AbstractHorseEntity
implements ClientVehicle {
    public static final float SITTING_HEIGHT_DIFFERENCE = 1.43f;
    private final CamelVehicleComponent vehicleComponent = new CamelVehicleComponent(this);

    public CamelEntity(EntitySpawnContext context) {
        super(context);
        this.dirtyMetadata.put(EntityDataTypes.CONTAINER_TYPE, (byte)ContainerType.HORSE.getId());
        this.setFlag(EntityFlag.TAMED, true);
    }

    @Override
    public void setHorseFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.EATING, (xd & 0x10) == 16);
        this.setFlag(EntityFlag.STANDING, (xd & 0x20) == 32);
        int horseFlags = 0;
        horseFlags = (xd & 0x40) == 64 ? horseFlags | 0x80 : horseFlags;
        horseFlags = (xd & 0x10) == 16 && (xd & 0x40) != 64 ? horseFlags | 0x20 : horseFlags;
        this.dirtyMetadata.put(EntityDataTypes.HORSE_FLAGS, horseFlags);
        if ((xd & 0x40) == 64) {
            EntityEventPacket entityEventPacket = new EntityEventPacket();
            entityEventPacket.setRuntimeEntityId(this.geyserId);
            entityEventPacket.setType(EntityEventType.EATING_ITEM);
            entityEventPacket.setData(this.session.getItemMappings().getStoredItems().wheat().getBedrockDefinition().getRuntimeId() << 16);
            this.session.sendUpstreamPacket(entityEventPacket);
        }
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.CAMEL_FOOD;
    }

    @Override
    public void setPose(Pose pose) {
        this.setFlag(EntityFlag.SITTING, pose == Pose.SITTING);
        super.setPose(pose);
    }

    @Override
    protected void setDimensionsFromPose(Pose pose) {
        if (pose == Pose.SITTING) {
            this.setBoundingBoxHeight(this.definition.height() - 1.43f);
            this.setBoundingBoxWidth(this.definition.width());
        } else {
            super.setDimensionsFromPose(pose);
        }
    }

    public void setDashing(BooleanEntityMetadata entityMetadata) {
        if (entityMetadata.getPrimitiveValue()) {
            this.setFlag(EntityFlag.HAS_DASH_COOLDOWN, true);
            this.vehicleComponent.startDashCooldown();
        } else if (!this.isClientControlled()) {
            this.setFlag(EntityFlag.HAS_DASH_COOLDOWN, false);
        }
    }

    public void setLastPoseTick(LongEntityMetadata entityMetadata) {
        this.vehicleComponent.setLastPoseTick(entityMetadata.getPrimitiveValue());
    }

    @Override
    protected AttributeData calculateAttribute(Attribute javaAttribute, GeyserAttributeType type) {
        AttributeData attributeData = super.calculateAttribute(javaAttribute, type);
        if (javaAttribute.getType() == AttributeType.Builtin.JUMP_STRENGTH) {
            this.vehicleComponent.setHorseJumpStrength(attributeData.getValue());
        }
        return attributeData;
    }

    @Override
    public VehicleComponent<?> getVehicleComponent() {
        return this.vehicleComponent;
    }

    @Override
    public boolean isClientControlled() {
        return this.getFlag(EntityFlag.SADDLED) && !this.passengers.isEmpty() && this.passengers.get(0) == this.session.getPlayerEntity();
    }

    @Override
    public float getVehicleSpeed() {
        float moveSpeed = this.vehicleComponent.getMoveSpeed();
        if (!this.getFlag(EntityFlag.HAS_DASH_COOLDOWN) && this.session.getPlayerEntity().getFlag(EntityFlag.SPRINTING)) {
            return moveSpeed + 0.1f;
        }
        return moveSpeed;
    }

    @Override
    public boolean canClimb() {
        return false;
    }
}

