/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.nautilus;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.animal.tameable.TameableEntity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.entity.vehicle.NautilusVehicleComponent;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.geyser.input.InputLocksFlag;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.enchantment.EnchantmentComponent;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.geyser.util.ItemUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;

public abstract class AbstractNautilusEntity
extends TameableEntity
implements ClientVehicle {
    private HolderSet repairableItems = null;
    private boolean isCurseOfBinding = false;
    private final NautilusVehicleComponent vehicleComponent;

    public AbstractNautilusEntity(EntitySpawnContext context, float defSpeed) {
        super(context);
        this.vehicleComponent = new NautilusVehicleComponent(this, 0.0f, defSpeed);
        this.dirtyMetadata.put(EntityDataTypes.CONTAINER_SIZE, 2);
        this.setFlag(EntityFlag.WASD_CONTROLLED, true);
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.NAUTILUS_FOOD;
    }

    @Override
    public void setBody(GeyserItemStack stack) {
        super.setBody(stack);
        this.isCurseOfBinding = ItemUtils.hasEffect(this.session, stack, EnchantmentComponent.PREVENT_ARMOR_CHANGE);
        this.repairableItems = stack.getComponent(DataComponentTypes.REPAIRABLE);
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.getFlag(EntityFlag.ANGRY)) {
            return InteractiveTag.NONE;
        }
        if (this.getFlag(EntityFlag.TAMED)) {
            if (itemInHand.asItem().javaIdentifier().endsWith("_nautilus_armor") && this.getItemInSlot(EquipmentSlot.BODY).isEmpty() && !this.getFlag(EntityFlag.BABY)) {
                return InteractiveTag.EQUIP_NAUTILUS_ARMOR;
            }
            if (itemInHand.is(Items.SHEARS) && !this.getItemInSlot(EquipmentSlot.BODY).isEmpty() && (!this.isCurseOfBinding || this.session.getGameMode().equals(GameMode.CREATIVE))) {
                return InteractiveTag.REMOVE_NAUTILUS_ARMOR;
            }
            if (itemInHand.is(this.session, this.repairableItems) && !this.getItemInSlot(EquipmentSlot.BODY).isEmpty() && this.getItemInSlot(EquipmentSlot.BODY).isDamaged()) {
                return InteractiveTag.REPAIR_WOLF_ARMOR;
            }
            if (itemInHand.isEmpty()) {
                return InteractiveTag.RIDE_HORSE;
            }
        } else if (this.getFlag(EntityFlag.BABY) || this.getFlag(EntityFlag.TAMED)) {
            if (itemInHand.is(this.session, ItemTag.NAUTILUS_FOOD)) {
                return InteractiveTag.FEED;
            }
        } else if (itemInHand.is(this.session, ItemTag.NAUTILUS_TAMING_ITEMS)) {
            return InteractiveTag.TAME;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected void updateSaddled(boolean saddled) {
        this.setFlag(EntityFlag.CAN_DASH, saddled);
        super.updateSaddled(saddled);
        if (this.passengers.contains(this.session.getPlayerEntity())) {
            this.session.setLockInput(InputLocksFlag.JUMP, this.doesJumpDismount());
            this.session.updateInputLocks();
        }
    }

    @Override
    public boolean doesJumpDismount() {
        return !this.getFlag(EntityFlag.SADDLED);
    }

    public void setDashing(BooleanEntityMetadata entityMetadata) {
        if (entityMetadata.getPrimitiveValue()) {
            this.vehicleComponent.setDashCooldown(40);
        }
    }

    @Override
    public VehicleComponent<?> getVehicleComponent() {
        return this.vehicleComponent;
    }

    @Override
    public Vector3f getRiddenInput(Vector2f input) {
        float x = input.getX();
        float y = 0.0f;
        float z = 0.0f;
        if (input.getY() != 0.0f) {
            float pitch = this.session.getPlayerEntity().getPitch();
            z = TrigMath.cos((double)pitch * (Math.PI / 180));
            y = -TrigMath.sin((double)pitch * (Math.PI / 180));
            if (input.getY() < 0.0f) {
                z *= -0.5f;
                y *= -0.5f;
            }
        }
        return Vector3f.from(x, y, z);
    }

    @Override
    public float getVehicleSpeed() {
        return this.vehicleComponent.isInWater() ? 0.0325f * this.vehicleComponent.getMoveSpeed() : 0.02f * this.vehicleComponent.getMoveSpeed();
    }

    @Override
    public boolean isClientControlled() {
        return this.getFlag(EntityFlag.SADDLED) && !this.passengers.isEmpty() && this.passengers.get(0) == this.session.getPlayerEntity();
    }

    @Override
    protected boolean canUseSlot(EquipmentSlot slot) {
        if (slot != EquipmentSlot.SADDLE && slot != EquipmentSlot.BODY) {
            return super.canUseSlot(slot);
        }
        return this.isAlive() && !this.isBaby() && this.getFlag(EntityFlag.TAMED);
    }
}

