/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.ParticleType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.cloudburstmc.protocol.bedrock.packet.SpawnParticleEffectPacket;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.type.living.MobEntity;
import org.geysermc.geyser.entity.type.living.monster.EnderDragonPartEntity;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;

public class EnderDragonEntity
extends MobEntity
implements Tickable {
    private EnderDragonPartEntity head;
    private EnderDragonPartEntity neck;
    private EnderDragonPartEntity body;
    private EnderDragonPartEntity leftWing;
    private EnderDragonPartEntity rightWing;
    private EnderDragonPartEntity[] tail;
    private EnderDragonPartEntity[] allParts;
    private final Segment[] segmentHistory = new Segment[19];
    private int latestSegment = -1;
    private int phase;
    private int phaseTicks;
    private int ticksTillNextGrowl = 100;
    private float wingPosition;
    private float lastWingPosition;

    public EnderDragonEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.setFlag(EntityFlag.FIRE_IMMUNE, true);
    }

    @Override
    public void setHealth(FloatEntityMetadata entityMetadata) {
        super.setHealth(entityMetadata);
        if (this.phase == 9 && this.health <= 0.0f) {
            EntityEventPacket entityEventPacket = new EntityEventPacket();
            entityEventPacket.setType(EntityEventType.ENDER_DRAGON_DEATH);
            entityEventPacket.setRuntimeEntityId(this.geyserId);
            entityEventPacket.setData(0);
            this.session.sendUpstreamPacket(entityEventPacket);
        }
    }

    public void setPhase(IntEntityMetadata entityMetadata) {
        this.phase = entityMetadata.getPrimitiveValue();
        this.phaseTicks = 0;
        this.setFlag(EntityFlag.SITTING, this.isSitting());
    }

    @Override
    public void spawnEntity() {
        super.spawnEntity();
        AtomicLong nextEntityId = this.session.getEntityCache().getNextEntityId();
        this.head = new EnderDragonPartEntity(this.session, this.entityId + 1, nextEntityId.incrementAndGet(), 1.0f, 1.0f);
        this.neck = new EnderDragonPartEntity(this.session, this.entityId + 2, nextEntityId.incrementAndGet(), 3.0f, 3.0f);
        this.body = new EnderDragonPartEntity(this.session, this.entityId + 3, nextEntityId.incrementAndGet(), 5.0f, 3.0f);
        this.leftWing = new EnderDragonPartEntity(this.session, this.entityId + 4, nextEntityId.incrementAndGet(), 4.0f, 2.0f);
        this.rightWing = new EnderDragonPartEntity(this.session, this.entityId + 5, nextEntityId.incrementAndGet(), 4.0f, 2.0f);
        this.tail = new EnderDragonPartEntity[3];
        for (int i = 0; i < 3; ++i) {
            this.tail[i] = new EnderDragonPartEntity(this.session, this.entityId + 6 + i, nextEntityId.incrementAndGet(), 2.0f, 2.0f);
        }
        for (EnderDragonPartEntity part : this.allParts = new EnderDragonPartEntity[]{this.head, this.neck, this.body, this.leftWing, this.rightWing, this.tail[0], this.tail[1], this.tail[2]}) {
            this.session.getEntityCache().spawnEntity(part);
        }
        for (int i = 0; i < this.segmentHistory.length; ++i) {
            this.segmentHistory[i] = new Segment();
            this.segmentHistory[i].yaw = this.getHeadYaw();
            this.segmentHistory[i].y = this.position.getY();
        }
    }

    @Override
    public void addAdditionalSpawnData(AddEntityPacket addEntityPacket) {
        addEntityPacket.getAttributes().add(this.createHealthAttribute());
    }

    @Override
    public void despawnEntity() {
        for (EnderDragonPartEntity part : this.allParts) {
            part.despawnEntity();
        }
        super.despawnEntity();
    }

    @Override
    protected boolean isEnemy() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        this.effectTick();
        if (!this.getFlag(EntityFlag.NO_AI) && this.isAlive()) {
            this.pushSegment();
            this.updateBoundingBoxes();
        }
    }

    @Override
    public boolean shouldLerp() {
        return false;
    }

    private void updateBoundingBoxes() {
        Vector3f facingDir = Vector3f.createDirectionDeg(0.0f, this.getHeadYaw());
        Segment baseSegment = this.getSegment(5);
        float pitch = (float)Math.toRadians(10.0f * (baseSegment.getY() - this.getSegment(10).getY()));
        float pitchXZ = (float)Math.cos(pitch);
        float pitchY = (float)Math.sin(pitch);
        float headDuck = this.isHovering() || this.isSitting() ? -1.0f : baseSegment.y - this.getSegment((int)0).y;
        this.head.setPosition(facingDir.up(pitchY).mul(pitchXZ, 1.0f, -pitchXZ).mul(6.5f).up(headDuck));
        this.neck.setPosition(facingDir.up(pitchY).mul(pitchXZ, 1.0f, -pitchXZ).mul(5.5f).up(headDuck));
        this.body.setPosition(facingDir.mul(0.5f, 0.0f, -0.5f));
        Vector3f wingPos = Vector3f.createDirectionDeg(0.0f, 90.0f - this.getHeadYaw()).mul(4.5f).up(2.0f);
        this.rightWing.setPosition(wingPos);
        this.leftWing.setPosition(wingPos.mul(-1.0f, 1.0f, -1.0f));
        Vector3f tailBase = facingDir.mul(1.5f);
        for (int i = 0; i < this.tail.length; ++i) {
            float distance = (float)(i + 1) * 2.0f;
            Segment targetSegment = this.getSegment(12 + 2 * i);
            float angle = this.getHeadYaw() + targetSegment.yaw - baseSegment.yaw;
            float tailYOffset = targetSegment.y - baseSegment.y - (distance + 1.5f) * pitchY + 1.5f;
            this.tail[i].setPosition(Vector3f.createDirectionDeg(0.0f, angle).mul(distance).add(tailBase).mul(-pitchXZ, 1.0f, pitchXZ).up(tailYOffset));
        }
        for (EnderDragonPartEntity part : this.allParts) {
            part.moveAbsoluteRaw(part.getPosition().add(this.position), 0.0f, 0.0f, 0.0f, false, false);
        }
    }

    private void effectTick() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (!this.silent) {
            if (Math.cos((double)(this.wingPosition * 2.0f) * Math.PI) <= (double)-0.3f && Math.cos((double)(this.lastWingPosition * 2.0f) * Math.PI) >= (double)-0.3f) {
                PlaySoundPacket playSoundPacket = new PlaySoundPacket();
                playSoundPacket.setSound("mob.enderdragon.flap");
                playSoundPacket.setPosition(this.position);
                playSoundPacket.setVolume(5.0f);
                playSoundPacket.setPitch(0.8f + ((Random)random).nextFloat() * 0.3f);
                this.session.sendUpstreamPacket(playSoundPacket);
            }
            if (!this.isSitting() && !this.isHovering() && this.ticksTillNextGrowl-- == 0) {
                this.playGrowlSound();
                this.ticksTillNextGrowl = 200 + ((Random)random).nextInt(200);
            }
            this.lastWingPosition = this.wingPosition;
        }
        if (this.isAlive()) {
            if (this.getFlag(EntityFlag.NO_AI)) {
                this.wingPosition = 0.5f;
            } else if (this.isHovering() || this.isSitting()) {
                this.wingPosition += 0.1f;
            } else {
                double speed = this.motion.length();
                this.wingPosition = (float)((double)this.wingPosition + (double)0.2f / (speed * 10.0 + 1.0) * Math.pow(2.0, this.motion.getY()));
            }
            ++this.phaseTicks;
            if (this.phase == 3) {
                float headHeight = this.head.getBoundingBoxHeight();
                Vector3f headCenter = this.head.getPosition().up(headHeight * 0.5f);
                for (int i = 0; i < 8; ++i) {
                    Vector3f particlePos = headCenter.add(random.nextGaussian() / 2.0, random.nextGaussian() / 2.0, random.nextGaussian() / 2.0);
                    LevelEventPacket particlePacket = new LevelEventPacket();
                    particlePacket.setType(ParticleType.DRAGON_BREATH);
                    particlePacket.setPosition(particlePos);
                    this.session.sendUpstreamPacket(particlePacket);
                }
            } else if (this.phase == 5) {
                if (this.phaseTicks % 2 == 0 && this.phaseTicks < 10) {
                    for (int i = 0; i < 8; ++i) {
                        SpawnParticleEffectPacket spawnParticleEffectPacket = new SpawnParticleEffectPacket();
                        spawnParticleEffectPacket.setDimensionId(DimensionUtils.javaToBedrock(this.session));
                        spawnParticleEffectPacket.setPosition(this.head.getPosition().add(random.nextGaussian() / 2.0, random.nextGaussian() / 2.0, random.nextGaussian() / 2.0));
                        spawnParticleEffectPacket.setIdentifier("minecraft:dragon_breath_fire");
                        spawnParticleEffectPacket.setMolangVariablesJson(Optional.empty());
                        this.session.sendUpstreamPacket(spawnParticleEffectPacket);
                    }
                }
            } else if (this.phase == 7) {
                this.playGrowlSound();
            } else if (this.phase == 9 && this.phaseTicks % 10 == 0) {
                float xOffset = 8.0f * (((Random)random).nextFloat() - 0.5f);
                float yOffset = 4.0f * (((Random)random).nextFloat() - 0.5f) + 2.0f;
                float zOffset = 8.0f * (((Random)random).nextFloat() - 0.5f);
                Vector3f particlePos = this.position.add(xOffset, yOffset, zOffset);
                LevelEventPacket particlePacket = new LevelEventPacket();
                particlePacket.setType(ParticleType.EXPLODE);
                particlePacket.setPosition(particlePos);
                this.session.sendUpstreamPacket(particlePacket);
            }
        }
    }

    private void playGrowlSound() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        PlaySoundPacket playSoundPacket = new PlaySoundPacket();
        playSoundPacket.setSound("mob.enderdragon.growl");
        playSoundPacket.setPosition(this.position);
        playSoundPacket.setVolume(2.5f);
        playSoundPacket.setPitch(0.8f + ((Random)random).nextFloat() * 0.3f);
        this.session.sendUpstreamPacket(playSoundPacket);
    }

    private boolean isHovering() {
        return this.phase == 10;
    }

    private boolean isSitting() {
        return this.phase == 5 || this.phase == 6 || this.phase == 7;
    }

    private void pushSegment() {
        this.latestSegment = (this.latestSegment + 1) % this.segmentHistory.length;
        this.segmentHistory[this.latestSegment].yaw = this.getHeadYaw();
        this.segmentHistory[this.latestSegment].y = this.position.getY();
    }

    private Segment getSegment(int index) {
        if ((index = (this.latestSegment - index) % this.segmentHistory.length) < 0) {
            index += this.segmentHistory.length;
        }
        return this.segmentHistory[index];
    }

    private static class Segment {
        private float yaw;
        private float y;

        @Generated
        public Segment() {
        }

        @Generated
        public float getYaw() {
            return this.yaw;
        }

        @Generated
        public float getY() {
            return this.y;
        }

        @Generated
        public void setYaw(float yaw) {
            this.yaw = yaw;
        }

        @Generated
        public void setY(float y) {
            this.y = y;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Segment)) {
                return false;
            }
            Segment other = (Segment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
                return false;
            }
            return Float.compare(this.getY(), other.getY()) == 0;
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Segment;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getYaw());
            result = result * 59 + Float.floatToIntBits(this.getY());
            return result;
        }

        @Generated
        public String toString() {
            return "EnderDragonEntity.Segment(yaw=" + this.getYaw() + ", y=" + this.getY() + ")";
        }
    }
}

