/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.updater;

import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;

public class UIInventoryUpdater
extends InventoryUpdater {
    public static final UIInventoryUpdater INSTANCE = new UIInventoryUpdater();

    @Override
    public void updateInventory(InventoryTranslator<?> translator, GeyserSession session, Inventory inventory) {
        super.updateInventory(translator, session, inventory);
        for (int i = 0; i < translator.size; ++i) {
            int bedrockSlot = translator.javaSlotToBedrock(i);
            if (bedrockSlot == 50) continue;
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            slotPacket.setContainerId(124);
            slotPacket.setSlot(bedrockSlot);
            slotPacket.setItem(inventory.getItem(i).getItemData(session));
            session.sendUpstreamPacket(slotPacket);
        }
    }

    @Override
    public boolean updateSlot(InventoryTranslator<?> translator, GeyserSession session, Inventory inventory, int javaSlot) {
        if (super.updateSlot(translator, session, inventory, javaSlot)) {
            return true;
        }
        InventorySlotPacket slotPacket = new InventorySlotPacket();
        slotPacket.setContainerId(124);
        slotPacket.setSlot(translator.javaSlotToBedrock(javaSlot));
        slotPacket.setItem(inventory.getItem(javaSlot).getItemData(session));
        session.sendUpstreamPacket(slotPacket);
        return true;
    }
}

