/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import lombok.Generated;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public enum EffectType {
    NONE(0, null, 0),
    SPEED(1, Effect.SPEED, 3402751),
    SLOWNESS(2, Effect.SLOWNESS, 9154528),
    HASTE(3, Effect.HASTE, 14270531),
    MINING_FATIGUE(4, Effect.MINING_FATIGUE, 4866583),
    STRENGTH(5, Effect.STRENGTH, 16762624),
    INSTANT_HEALTH(6, Effect.INSTANT_HEALTH, 16262179),
    INSTANT_DAMAGE(7, Effect.INSTANT_DAMAGE, 11101546),
    JUMP_BOOST(8, Effect.JUMP_BOOST, 16646020),
    NAUSEA(9, Effect.NAUSEA, 5578058),
    REGENERATION(10, Effect.REGENERATION, 13458603),
    RESISTANCE(11, Effect.RESISTANCE, 9520880),
    FIRE_RESISTANCE(12, Effect.FIRE_RESISTANCE, 0xFF9900),
    WATER_BREATHING(13, Effect.WATER_BREATHING, 10017472),
    INVISIBILITY(14, Effect.INVISIBILITY, 0xF6F6F6),
    BLINDNESS(15, Effect.BLINDNESS, 2039587),
    NIGHT_VISION(16, Effect.NIGHT_VISION, 12779366),
    HUNGER(17, Effect.HUNGER, 5797459),
    WEAKNESS(18, Effect.WEAKNESS, 0x484D48),
    POISON(19, Effect.POISON, 8889187),
    WITHER(20, Effect.WITHER, 7561558),
    HEALTH_BOOST(21, Effect.HEALTH_BOOST, 16284963),
    ABSORPTION(22, Effect.ABSORPTION, 0x2552A5),
    SATURATION(23, Effect.SATURATION, 16262179),
    LEVITATION(24, Effect.LEVITATION, 0xCEFFFF),
    FATAL_POISON(25, null, 5149489),
    CONDUIT_POWER(26, Effect.CONDUIT_POWER, 1950417),
    SLOW_FALLING(27, Effect.SLOW_FALLING, 15978425),
    BAD_OMEN(28, Effect.BAD_OMEN, 745784),
    HERO_OF_THE_VILLAGE(29, Effect.HERO_OF_THE_VILLAGE, 0x44FF44),
    DARKNESS(30, Effect.DARKNESS, 2696993),
    TRIAL_OMEN(31, Effect.TRIAL_OMEN, 0x16A6A6),
    WIND_CHARGED(32, Effect.WIND_CHARGED, 12438015),
    WEAVING(33, Effect.WEAVING, 7891290),
    OOZING(34, Effect.OOZING, 10092451),
    INFESTED(35, Effect.INFESTED, 9214860),
    RAID_OMEN(36, Effect.RAID_OMEN, 14565464),
    BREATH_OF_THE_NAUTILUS(37, Effect.BREATH_OF_THE_NAUTILUS, 65518),
    GLOWING(0, Effect.GLOWING, 9740385),
    LUCK(0, Effect.LUCK, 5882118),
    BAD_LUCK(0, Effect.UNLUCK, 12624973),
    DOLPHINS_GRACE(0, Effect.DOLPHINS_GRACE, 8954814);

    private final int bedrockId;
    private final Effect javaEffect;
    private final int color;

    private EffectType(int bedrockId, Effect javaEffect, int color) {
        this.bedrockId = bedrockId;
        this.javaEffect = javaEffect;
        this.color = color;
    }

    public static EffectType fromJavaEffect(Effect effect) {
        for (EffectType type : EffectType.values()) {
            if (type.getJavaEffect() != effect) continue;
            return type;
        }
        return NONE;
    }

    public static EffectType fromColor(int color) {
        color &= 0xFFFFFF;
        for (EffectType type : EffectType.values()) {
            if (type.getColor() != color) continue;
            return type;
        }
        return NONE;
    }

    @Generated
    public int getBedrockId() {
        return this.bedrockId;
    }

    @Generated
    public Effect getJavaEffect() {
        return this.javaEffect;
    }

    @Generated
    public int getColor() {
        return this.color;
    }
}

