/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block.property;

import java.util.Locale;
import java.util.Optional;
import org.geysermc.geyser.level.block.property.Property;

public final class EnumProperty<T extends Enum<T>>
extends Property<T> {
    private final T[] values;

    private EnumProperty(String name, T[] values) {
        super(name);
        this.values = values;
    }

    @Override
    public int valuesCount() {
        return this.values.length;
    }

    @Override
    public int indexOf(T value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (value != this.values[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Property " + String.valueOf(this) + " does not have value " + String.valueOf(value));
    }

    @Override
    public Optional<T> valueOf(String string) {
        for (T value : this.values) {
            if (!((Enum)value).name().toLowerCase(Locale.ROOT).equals(string)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumProperty<T> create(String name, T ... values) {
        return new EnumProperty(name, values);
    }
}

