/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import io.netty.buffer.ByteBuf;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.BedrockPacketSerializer;
import org.cloudburstmc.protocol.bedrock.codec.v291.serializer.MobEquipmentSerializer_v291;
import org.cloudburstmc.protocol.bedrock.codec.v291.serializer.MoveEntityAbsoluteSerializer_v291;
import org.cloudburstmc.protocol.bedrock.codec.v291.serializer.PlayerHotbarSerializer_v291;
import org.cloudburstmc.protocol.bedrock.codec.v291.serializer.SetEntityLinkSerializer_v291;
import org.cloudburstmc.protocol.bedrock.codec.v390.serializer.PlayerSkinSerializer_v390;
import org.cloudburstmc.protocol.bedrock.codec.v419.serializer.MovePlayerSerializer_v419;
import org.cloudburstmc.protocol.bedrock.codec.v486.serializer.BossEventSerializer_v486;
import org.cloudburstmc.protocol.bedrock.codec.v557.serializer.SetEntityDataSerializer_v557;
import org.cloudburstmc.protocol.bedrock.codec.v662.serializer.SetEntityMotionSerializer_v662;
import org.cloudburstmc.protocol.bedrock.codec.v712.serializer.MobArmorEquipmentSerializer_v712;
import org.cloudburstmc.protocol.bedrock.codec.v748.serializer.InventoryContentSerializer_v748;
import org.cloudburstmc.protocol.bedrock.codec.v748.serializer.InventorySlotSerializer_v748;
import org.cloudburstmc.protocol.bedrock.codec.v776.serializer.BossEventSerializer_v776;
import org.cloudburstmc.protocol.bedrock.packet.AnvilDamagePacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BossEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.ClientCacheBlobStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.ClientCacheStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.ClientCheatAbilityPacket;
import org.cloudburstmc.protocol.bedrock.packet.ClientToServerHandshakePacket;
import org.cloudburstmc.protocol.bedrock.packet.CodeBuilderSourcePacket;
import org.cloudburstmc.protocol.bedrock.packet.CraftingEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.CreatePhotoPacket;
import org.cloudburstmc.protocol.bedrock.packet.DebugInfoPacket;
import org.cloudburstmc.protocol.bedrock.packet.EditorNetworkPacket;
import org.cloudburstmc.protocol.bedrock.packet.EntityFallPacket;
import org.cloudburstmc.protocol.bedrock.packet.GameTestRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventoryContentPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.cloudburstmc.protocol.bedrock.packet.LabTablePacket;
import org.cloudburstmc.protocol.bedrock.packet.MapCreateLockedCopyPacket;
import org.cloudburstmc.protocol.bedrock.packet.MapInfoRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.MobArmorEquipmentPacket;
import org.cloudburstmc.protocol.bedrock.packet.MobEquipmentPacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.MultiplayerSettingsPacket;
import org.cloudburstmc.protocol.bedrock.packet.NpcRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.PhotoInfoRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.PhotoTransferPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerHotbarPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerInputPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerSkinPacket;
import org.cloudburstmc.protocol.bedrock.packet.PurchaseReceiptPacket;
import org.cloudburstmc.protocol.bedrock.packet.RefreshEntitlementsPacket;
import org.cloudburstmc.protocol.bedrock.packet.RiderJumpPacket;
import org.cloudburstmc.protocol.bedrock.packet.ScriptMessagePacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityLinkPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityMotionPacket;
import org.cloudburstmc.protocol.bedrock.packet.SettingsCommandPacket;
import org.cloudburstmc.protocol.bedrock.packet.SimpleEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.SubChunkRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.SubClientLoginPacket;
import org.cloudburstmc.protocol.common.util.VarInts;

class CodecProcessor {
    private static final BedrockPacketSerializer ILLEGAL_SERIALIZER = new BedrockPacketSerializer<BedrockPacket>(){

        @Override
        public void serialize(ByteBuf buffer, BedrockCodecHelper helper, BedrockPacket packet) {
            throw new IllegalArgumentException("Server tried to send unused packet " + packet.getClass().getSimpleName() + "!");
        }

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, BedrockPacket packet) {
            throw new IllegalArgumentException("Client tried to send unused packet " + packet.getClass().getSimpleName() + "!");
        }
    };
    private static final BedrockPacketSerializer IGNORED_SERIALIZER = new BedrockPacketSerializer<BedrockPacket>(){

        @Override
        public void serialize(ByteBuf buffer, BedrockCodecHelper helper, BedrockPacket packet) {
        }

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, BedrockPacket packet) {
        }
    };
    private static final BedrockPacketSerializer<InventoryContentPacket> INVENTORY_CONTENT_SERIALIZER_V748 = new InventoryContentSerializer_v748(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, InventoryContentPacket packet) {
            throw new IllegalArgumentException("Client cannot send InventoryContentPacket in server-auth inventory environment!");
        }
    };
    private static final BedrockPacketSerializer<InventorySlotPacket> INVENTORY_SLOT_SERIALIZER_V748 = new InventorySlotSerializer_v748(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, InventorySlotPacket packet) {
            throw new IllegalArgumentException("Client cannot send InventorySlotPacket in server-auth inventory environment!");
        }
    };
    private static final BedrockPacketSerializer<MovePlayerPacket> MOVE_PLAYER_SERIALIZER = new MovePlayerSerializer_v419(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, MovePlayerPacket packet) {
            throw new IllegalArgumentException("Client cannot send MovePlayerPacket in server-auth movement environment!");
        }
    };
    private static final BedrockPacketSerializer<MoveEntityAbsolutePacket> MOVE_ENTITY_SERIALIZER = new MoveEntityAbsoluteSerializer_v291(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, MoveEntityAbsolutePacket packet) {
            throw new IllegalArgumentException("Client cannot send MoveEntityAbsolutePacket in server-auth movement environment!");
        }
    };
    private static final BedrockPacketSerializer<BossEventPacket> BOSS_EVENT_SERIALIZER_486 = new BossEventSerializer_v486(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, BossEventPacket packet) {
        }
    };
    private static final BedrockPacketSerializer<BossEventPacket> BOSS_EVENT_SERIALIZER_776 = new BossEventSerializer_v776(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, BossEventPacket packet) {
        }
    };
    private static final BedrockPacketSerializer<MobArmorEquipmentPacket> MOB_ARMOR_EQUIPMENT_SERIALIZER = new MobArmorEquipmentSerializer_v712(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, MobArmorEquipmentPacket packet) {
        }
    };
    private static final BedrockPacketSerializer<PlayerHotbarPacket> PLAYER_HOTBAR_SERIALIZER = new PlayerHotbarSerializer_v291(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, PlayerHotbarPacket packet) {
        }
    };
    private static final BedrockPacketSerializer<PlayerSkinPacket> PLAYER_SKIN_SERIALIZER = new PlayerSkinSerializer_v390(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, PlayerSkinPacket packet) {
        }
    };
    private static final BedrockPacketSerializer<SetEntityDataPacket> SET_ENTITY_DATA_SERIALIZER = new SetEntityDataSerializer_v557(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, SetEntityDataPacket packet) {
        }
    };
    private static final BedrockPacketSerializer<SetEntityMotionPacket> SET_ENTITY_MOTION_SERIALIZER = new SetEntityMotionSerializer_v662(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, SetEntityMotionPacket packet) {
        }
    };
    private static final BedrockPacketSerializer<SetEntityLinkPacket> SET_ENTITY_LINK_SERIALIZER = new SetEntityLinkSerializer_v291(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, SetEntityLinkPacket packet) {
        }
    };
    private static final BedrockPacketSerializer<MobEquipmentPacket> MOB_EQUIPMENT_SERIALIZER = new MobEquipmentSerializer_v291(){

        @Override
        public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, MobEquipmentPacket packet) {
            packet.setRuntimeEntityId(VarInts.readUnsignedLong(buffer));
            CodecProcessor.fakeItemRead(buffer);
            packet.setInventorySlot(buffer.readUnsignedByte());
            packet.setHotbarSlot(buffer.readUnsignedByte());
            packet.setContainerId(buffer.readByte());
        }
    };

    CodecProcessor() {
    }

    static BedrockCodec processCodec(BedrockCodec codec) {
        BedrockPacketSerializer<BossEventPacket> bossEventSerializer = codec.getProtocolVersion() >= 776 ? BOSS_EVENT_SERIALIZER_776 : BOSS_EVENT_SERIALIZER_486;
        BedrockCodec.Builder codecBuilder = codec.toBuilder().updateSerializer(PhotoTransferPacket.class, ILLEGAL_SERIALIZER).updateSerializer(LabTablePacket.class, ILLEGAL_SERIALIZER).updateSerializer(CodeBuilderSourcePacket.class, ILLEGAL_SERIALIZER).updateSerializer(CreatePhotoPacket.class, ILLEGAL_SERIALIZER).updateSerializer(NpcRequestPacket.class, ILLEGAL_SERIALIZER).updateSerializer(PhotoInfoRequestPacket.class, ILLEGAL_SERIALIZER).updateSerializer(ClientCheatAbilityPacket.class, ILLEGAL_SERIALIZER).updateSerializer(CraftingEventPacket.class, ILLEGAL_SERIALIZER).updateSerializer(ClientCacheBlobStatusPacket.class, ILLEGAL_SERIALIZER).updateSerializer(SubClientLoginPacket.class, ILLEGAL_SERIALIZER).updateSerializer(SubChunkRequestPacket.class, ILLEGAL_SERIALIZER).updateSerializer(GameTestRequestPacket.class, ILLEGAL_SERIALIZER).updateSerializer(ClientToServerHandshakePacket.class, IGNORED_SERIALIZER).updateSerializer(EntityFallPacket.class, IGNORED_SERIALIZER).updateSerializer(MapCreateLockedCopyPacket.class, IGNORED_SERIALIZER).updateSerializer(MapInfoRequestPacket.class, IGNORED_SERIALIZER).updateSerializer(SettingsCommandPacket.class, IGNORED_SERIALIZER).updateSerializer(AnvilDamagePacket.class, IGNORED_SERIALIZER).updateSerializer(InventoryContentPacket.class, INVENTORY_CONTENT_SERIALIZER_V748).updateSerializer(InventorySlotPacket.class, INVENTORY_SLOT_SERIALIZER_V748).updateSerializer(MovePlayerPacket.class, MOVE_PLAYER_SERIALIZER).updateSerializer(MoveEntityAbsolutePacket.class, MOVE_ENTITY_SERIALIZER).updateSerializer(BossEventPacket.class, bossEventSerializer).updateSerializer(MobArmorEquipmentPacket.class, MOB_ARMOR_EQUIPMENT_SERIALIZER).updateSerializer(PlayerHotbarPacket.class, PLAYER_HOTBAR_SERIALIZER).updateSerializer(PlayerSkinPacket.class, PLAYER_SKIN_SERIALIZER).updateSerializer(SetEntityDataPacket.class, SET_ENTITY_DATA_SERIALIZER).updateSerializer(SetEntityMotionPacket.class, SET_ENTITY_MOTION_SERIALIZER).updateSerializer(SetEntityLinkPacket.class, SET_ENTITY_LINK_SERIALIZER).updateSerializer(MobEquipmentPacket.class, MOB_EQUIPMENT_SERIALIZER).updateSerializer(DebugInfoPacket.class, ILLEGAL_SERIALIZER).updateSerializer(EditorNetworkPacket.class, ILLEGAL_SERIALIZER).updateSerializer(ScriptMessagePacket.class, ILLEGAL_SERIALIZER).updateSerializer(ClientCacheStatusPacket.class, IGNORED_SERIALIZER).updateSerializer(SimpleEventPacket.class, IGNORED_SERIALIZER).updateSerializer(MultiplayerSettingsPacket.class, IGNORED_SERIALIZER);
        if (codec.getProtocolVersion() < 800) {
            codecBuilder.updateSerializer(RiderJumpPacket.class, ILLEGAL_SERIALIZER).updateSerializer(PlayerInputPacket.class, ILLEGAL_SERIALIZER);
        }
        if (!Boolean.getBoolean("Geyser.ReceiptPackets")) {
            codecBuilder.updateSerializer(RefreshEntitlementsPacket.class, IGNORED_SERIALIZER);
            codecBuilder.updateSerializer(PurchaseReceiptPacket.class, IGNORED_SERIALIZER);
        }
        return codecBuilder.build();
    }

    private static void fakeItemRead(ByteBuf buffer) {
        int id = VarInts.readInt(buffer);
        if (id == 0) {
            return;
        }
        buffer.skipBytes(2);
        VarInts.readUnsignedInt(buffer);
        boolean hasNetId = buffer.readBoolean();
        if (hasNetId) {
            VarInts.readInt(buffer);
        }
        VarInts.readInt(buffer);
        int streamSize = VarInts.readUnsignedInt(buffer);
        buffer.skipBytes(streamSize);
    }
}

