/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.stream.Stream;
import lombok.Generated;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.session.GeyserSession;

public class InvalidPacketHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "rak-error-handler";
    private final GeyserSession session;

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Throwable rootCause = Stream.iterate(cause, Throwable::getCause).filter(element -> element.getCause() == null).findFirst().orElse(cause);
        GeyserLogger logger = GeyserImpl.getInstance().getLogger();
        if (!(rootCause instanceof IllegalArgumentException)) {
            logger.error("Exception caught in session of " + this.session.bedrockUsername(), cause);
            this.session.disconnect("An internal error occurred!");
            this.session.forciblyCloseUpstream();
            return;
        }
        logger.error("Illegal packet from " + this.session.bedrockUsername(), cause);
        this.session.disconnect("Invalid packet received!");
        this.session.forciblyCloseUpstream();
    }

    @Generated
    public InvalidPacketHandler(GeyserSession session) {
        this.session = session;
    }
}

