/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.velocity;

import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.proxy.network.TransportType;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoEventLoop;
import io.netty.channel.IoEventLoopGroup;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.SingleThreadIoEventLoop;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalIoHandler;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.ThreadAwareExecutor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.network.netty.GeyserInjector;
import org.geysermc.geyser.network.netty.IoHandlerWrapper;
import org.geysermc.geyser.network.netty.LocalServerChannelWrapper;
import org.geysermc.geyser.platform.velocity.GeyserVelocityCompressionDisabler;

public class GeyserVelocityInjector
extends GeyserInjector {
    private final ProxyServer proxy;

    public GeyserVelocityInjector(ProxyServer proxy) {
        this.proxy = proxy;
    }

    @Override
    protected void initializeLocalChannel0(final GeyserBootstrap bootstrap) throws Exception {
        ChannelFuture channelFuture;
        try {
            Class.forName("io.netty.channel.MultiThreadIoEventLoopGroup");
        }
        catch (ClassNotFoundException e) {
            bootstrap.getGeyserLogger().error("use-direct-connection disabled as Velocity is not up-to-date.");
            return;
        }
        Field cm = this.proxy.getClass().getDeclaredField("cm");
        cm.setAccessible(true);
        Object connectionManager = cm.get(this.proxy);
        Class<?> connectionManagerClass = connectionManager.getClass();
        Supplier serverChannelInitializerHolder = (Supplier)connectionManagerClass.getMethod("getServerChannelInitializer", new Class[0]).invoke(connectionManager, new Object[0]);
        final ChannelInitializer channelInitializer = (ChannelInitializer)serverChannelInitializerHolder.get();
        Field serverWriteMarkField = connectionManagerClass.getDeclaredField("SERVER_WRITE_MARK");
        serverWriteMarkField.setAccessible(true);
        WriteBufferWaterMark serverWriteMark = (WriteBufferWaterMark)serverWriteMarkField.get(null);
        Field workerGroupField = connectionManagerClass.getDeclaredField("workerGroup");
        workerGroupField.setAccessible(true);
        final IoEventLoopGroup workerGroup = (IoEventLoopGroup)workerGroupField.get(connectionManager);
        final IoHandlerFactory factory = LocalIoHandler.newFactory();
        final IoHandlerFactory nativeFactory = GeyserVelocityInjector.getNativeHandlerFactory();
        IoHandlerFactory wrapperFactory = new IoHandlerFactory(){

            public IoHandler newHandler(ThreadAwareExecutor ioExecutor) {
                return new IoHandlerWrapper(factory.newHandler(ioExecutor), nativeFactory.newHandler(ioExecutor));
            }
        };
        MultiThreadIoEventLoopGroup wrapperGroup = new MultiThreadIoEventLoopGroup(factory, wrapperFactory){
            final /* synthetic */ 1 val$wrapperFactory;
            {
                this.val$wrapperFactory = var4_4;
                super(ioHandlerFactory);
            }

            protected ThreadFactory newDefaultThreadFactory() {
                return new DefaultThreadFactory("Geyser Backend Worker Group", 10);
            }

            protected IoEventLoop newChild(Executor executor, IoHandlerFactory ioHandlerFactory, Object ... args) {
                return new SingleThreadIoEventLoop(workerGroup, executor, (IoHandlerFactory)this.val$wrapperFactory);
            }
        };
        final Method initChannel = ChannelInitializer.class.getDeclaredMethod("initChannel", Channel.class);
        initChannel.setAccessible(true);
        this.localChannel = channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannelWrapper.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(@NonNull Channel ch) throws Exception {
                initChannel.invoke((Object)channelInitializer, ch);
                if (bootstrap.config().advanced().java().disableCompression() && GeyserVelocityCompressionDisabler.ENABLED) {
                    ch.pipeline().addAfter("minecraft-encoder", "geyser-compression-disabler", (ChannelHandler)new GeyserVelocityCompressionDisabler());
                }
            }
        }).group((EventLoopGroup)new MultiThreadIoEventLoopGroup(LocalIoHandler.newFactory()), (EventLoopGroup)wrapperGroup).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)serverWriteMark).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
        this.serverSocketAddress = channelFuture.channel().localAddress();
    }

    private static IoHandlerFactory getNativeHandlerFactory() {
        return switch (TransportType.bestType()) {
            default -> throw new IncompatibleClassChangeError();
            case TransportType.NIO -> NioIoHandler.newFactory();
            case TransportType.EPOLL -> EpollIoHandler.newFactory();
            case TransportType.KQUEUE -> KQueueIoHandler.newFactory();
            case TransportType.IO_URING -> IoUringIoHandler.newFactory();
        };
    }
}

