/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.velocity.shaded.org.spongepowered.configurate.transformation;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.velocity.shaded.org.spongepowered.configurate.ConfigurateException;
import org.geysermc.geyser.platform.velocity.shaded.org.spongepowered.configurate.ConfigurationNode;
import org.geysermc.geyser.platform.velocity.shaded.org.spongepowered.configurate.transformation.ConfigurationTransformation;

class ChainedConfigurationTransformation
implements ConfigurationTransformation {
    private final ConfigurationTransformation[] transformations;

    ChainedConfigurationTransformation(ConfigurationTransformation[] transformations) {
        this.transformations = Arrays.copyOf(transformations, transformations.length);
    }

    @Override
    public void apply(ConfigurationNode node) throws ConfigurateException {
        @Nullable ConfigurateException thrown = null;
        for (ConfigurationTransformation transformation : this.transformations) {
            try {
                transformation.apply(node);
            }
            catch (ConfigurateException ex) {
                if (thrown == null) {
                    thrown = ex;
                    continue;
                }
                thrown.addSuppressed(ex);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }
}

