/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.auth;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import lombok.Generated;
import org.geysermc.floodgate.util.DeviceOs;
import org.geysermc.floodgate.util.InputMode;
import org.geysermc.floodgate.util.UiProfile;

public final class BedrockClientData {
    @SerializedName(value="GameVersion")
    private String gameVersion;
    @SerializedName(value="ServerAddress")
    private String serverAddress;
    @SerializedName(value="ThirdPartyName")
    private String username;
    @SerializedName(value="LanguageCode")
    private String languageCode;
    @SerializedName(value="SkinId")
    private String skinId;
    @SerializedName(value="SkinData")
    @JsonAdapter(value=StringToByteDeserializer.class)
    private byte[] skinData;
    @SerializedName(value="SkinImageHeight")
    private int skinImageHeight;
    @SerializedName(value="SkinImageWidth")
    private int skinImageWidth;
    @SerializedName(value="CapeId")
    private String capeId;
    @SerializedName(value="CapeData")
    @JsonAdapter(value=StringToByteDeserializer.class)
    private byte[] capeData;
    @SerializedName(value="CapeImageHeight")
    private int capeImageHeight;
    @SerializedName(value="CapeImageWidth")
    private int capeImageWidth;
    @SerializedName(value="CapeOnClassicSkin")
    private boolean capeOnClassicSkin;
    @SerializedName(value="SkinResourcePatch")
    @JsonAdapter(value=StringToByteDeserializer.class)
    private byte[] geometryName;
    @SerializedName(value="SkinGeometryData")
    @JsonAdapter(value=StringToByteDeserializer.class)
    private byte[] geometryData;
    @SerializedName(value="PersonaSkin")
    private boolean personaSkin;
    @SerializedName(value="PremiumSkin")
    private boolean premiumSkin;
    @SerializedName(value="DeviceId")
    private String deviceId;
    @SerializedName(value="DeviceModel")
    private String deviceModel;
    @SerializedName(value="DeviceOS")
    @JsonAdapter(value=IntToEnumTypeFactory.class)
    private DeviceOs deviceOs;
    @SerializedName(value="UIProfile")
    @JsonAdapter(value=IntToEnumTypeFactory.class)
    private UiProfile uiProfile;
    @SerializedName(value="GuiScale")
    private int guiScale;
    @SerializedName(value="CurrentInputMode")
    @JsonAdapter(value=IntToEnumTypeFactory.class)
    private InputMode currentInputMode;
    @SerializedName(value="DefaultInputMode")
    @JsonAdapter(value=IntToEnumTypeFactory.class)
    private InputMode defaultInputMode;
    @SerializedName(value="PlatformOnlineId")
    private String platformOnlineId;
    @SerializedName(value="PlatformOfflineId")
    private String platformOfflineId;
    @SerializedName(value="SelfSignedId")
    private UUID selfSignedId;
    @SerializedName(value="ClientRandomId")
    private long clientRandomId;
    @SerializedName(value="ArmSize")
    private String armSize;
    @SerializedName(value="SkinAnimationData")
    private String skinAnimationData;
    @SerializedName(value="SkinColor")
    private String skinColor;
    @SerializedName(value="ThirdPartyNameOnly")
    private boolean thirdPartyNameOnly;
    @SerializedName(value="PlayFabId")
    private String playFabId;
    private transient String originalString = null;

    public DeviceOs getDeviceOs() {
        return this.deviceOs != null ? this.deviceOs : DeviceOs.UNKNOWN;
    }

    public InputMode getCurrentInputMode() {
        return this.currentInputMode != null ? this.currentInputMode : InputMode.UNKNOWN;
    }

    public InputMode getDefaultInputMode() {
        return this.defaultInputMode != null ? this.defaultInputMode : InputMode.UNKNOWN;
    }

    public UiProfile getUiProfile() {
        return this.uiProfile != null ? this.uiProfile : UiProfile.CLASSIC;
    }

    @Generated
    public String getGameVersion() {
        return this.gameVersion;
    }

    @Generated
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Generated
    public String getSkinId() {
        return this.skinId;
    }

    @Generated
    public byte[] getSkinData() {
        return this.skinData;
    }

    @Generated
    public int getSkinImageHeight() {
        return this.skinImageHeight;
    }

    @Generated
    public int getSkinImageWidth() {
        return this.skinImageWidth;
    }

    @Generated
    public String getCapeId() {
        return this.capeId;
    }

    @Generated
    public byte[] getCapeData() {
        return this.capeData;
    }

    @Generated
    public int getCapeImageHeight() {
        return this.capeImageHeight;
    }

    @Generated
    public int getCapeImageWidth() {
        return this.capeImageWidth;
    }

    @Generated
    public boolean isCapeOnClassicSkin() {
        return this.capeOnClassicSkin;
    }

    @Generated
    public byte[] getGeometryName() {
        return this.geometryName;
    }

    @Generated
    public byte[] getGeometryData() {
        return this.geometryData;
    }

    @Generated
    public boolean isPersonaSkin() {
        return this.personaSkin;
    }

    @Generated
    public boolean isPremiumSkin() {
        return this.premiumSkin;
    }

    @Generated
    public String getDeviceId() {
        return this.deviceId;
    }

    @Generated
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Generated
    public int getGuiScale() {
        return this.guiScale;
    }

    @Generated
    public String getPlatformOnlineId() {
        return this.platformOnlineId;
    }

    @Generated
    public String getPlatformOfflineId() {
        return this.platformOfflineId;
    }

    @Generated
    public UUID getSelfSignedId() {
        return this.selfSignedId;
    }

    @Generated
    public long getClientRandomId() {
        return this.clientRandomId;
    }

    @Generated
    public String getArmSize() {
        return this.armSize;
    }

    @Generated
    public String getSkinAnimationData() {
        return this.skinAnimationData;
    }

    @Generated
    public String getSkinColor() {
        return this.skinColor;
    }

    @Generated
    public boolean isThirdPartyNameOnly() {
        return this.thirdPartyNameOnly;
    }

    @Generated
    public String getPlayFabId() {
        return this.playFabId;
    }

    @Generated
    public String getOriginalString() {
        return this.originalString;
    }

    @Generated
    public void setOriginalString(String originalString) {
        this.originalString = originalString;
    }

    private static final class IntToEnumTypeFactory
    implements TypeAdapterFactory {
        private IntToEnumTypeFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class rawType = type.getRawType();
            if (!rawType.isEnum()) {
                return null;
            }
            final Object[] constants = rawType.getEnumConstants();
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) {
                }

                public T read(JsonReader in) throws IOException {
                    int ordinal = in.nextInt();
                    if (ordinal < 0 || ordinal >= constants.length) {
                        return null;
                    }
                    return constants[ordinal];
                }
            };
        }
    }

    private static final class StringToByteDeserializer
    implements JsonDeserializer<byte[]> {
        private StringToByteDeserializer() {
        }

        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Base64.getDecoder().decode(json.getAsString().getBytes(StandardCharsets.UTF_8));
        }
    }
}

