/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision.fixes;

import lombok.Generated;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="^bell$", passDefaultBoxes=true)
public class BellCollision
extends BlockCollision {
    private static final double MAX_PUSH_DISTANCE = 0.1875101;
    private final boolean standing;

    public BellCollision(BlockState state, BoundingBox[] boxes) {
        super(boxes);
        this.standing = state.getValue(Properties.BELL_ATTACHMENT).equals("floor");
    }

    @Override
    protected void correctPosition(GeyserSession session, int x, int y, int z, BoundingBox blockCollision, BoundingBox playerCollision) {
        if (!this.standing) {
            return;
        }
        blockCollision.pushOutOfBoundingBox(playerCollision, Direction.UP, 0.1875101);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BellCollision)) {
            return false;
        }
        BellCollision other = (BellCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.standing == other.standing;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BellCollision;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.standing ? 79 : 97);
        return result;
    }
}

