/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision.fixes;

import lombok.Generated;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="^scaffolding$", usesParams=true, passDefaultBoxes=true)
public class ScaffoldingCollision
extends BlockCollision {
    private final boolean bottom;

    public ScaffoldingCollision(BlockState state, BoundingBox[] defaultBoxes) {
        super(defaultBoxes);
        this.bottom = state.getValue(Properties.BOTTOM) != false && state.getValue(Properties.STABILITY_DISTANCE) != 0;
    }

    @Override
    public void correctPosition(GeyserSession session, int x, int y, int z, BoundingBox playerCollision) {
        double distance;
        boolean canStandOn;
        playerCollision.setSizeY(playerCollision.getSizeY() - 0.001);
        playerCollision.setMiddleY(playerCollision.getMiddleY() + 0.002);
        boolean intersected = this.checkIntersection(x, y, z, playerCollision);
        playerCollision.setSizeY(playerCollision.getSizeY() + 0.001);
        playerCollision.setMiddleY(playerCollision.getMiddleY() - 0.002);
        boolean bl = canStandOn = playerCollision.getMin(Axis.Y) >= (double)(y + 1) && !session.isSneaking();
        if (!canStandOn && this.bottom && playerCollision.getMin(Axis.Y) >= (double)y && Math.abs(distance = (double)y + 0.125 - playerCollision.getMin(Axis.Y)) < 0.12501009999990464) {
            playerCollision.translate(0.0, distance, 0.0);
        }
        if (intersected) {
            session.getCollisionManager().setTouchingScaffolding(true);
            session.getCollisionManager().setOnScaffolding(true);
        } else {
            playerCollision.setSizeY(playerCollision.getSizeY() + 0.001);
            playerCollision.setMiddleY(playerCollision.getMiddleY() - 0.002);
            if (this.checkIntersection(x, y, z, playerCollision)) {
                session.getCollisionManager().setOnScaffolding(true);
            }
            playerCollision.setSizeY(playerCollision.getSizeY() - 0.001);
            playerCollision.setMiddleY(playerCollision.getMiddleY() + 0.002);
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScaffoldingCollision)) {
            return false;
        }
        ScaffoldingCollision other = (ScaffoldingCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.bottom == other.bottom;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScaffoldingCollision;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bottom ? 79 : 97);
        return result;
    }
}

