/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision.fixes;

import lombok.Generated;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="_trapdoor$", usesParams=true, passDefaultBoxes=true)
public class TrapdoorCollision
extends BlockCollision {
    private static final double MAX_PUSH_DISTANCE = 0.0050101;
    private final Direction facing;

    public TrapdoorCollision(BlockState state, BoundingBox[] defaultBoxes) {
        super(defaultBoxes);
        this.facing = state.getValue(Properties.OPEN) != false ? state.getValue(Properties.HORIZONTAL_FACING) : (state.getValue(Properties.HALF).equals("bottom") ? Direction.UP : Direction.DOWN);
    }

    @Override
    protected void correctPosition(GeyserSession session, int x, int y, int z, BoundingBox blockCollision, BoundingBox playerCollision) {
        blockCollision.pushOutOfBoundingBox(playerCollision, this.facing, 0.0050101);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrapdoorCollision)) {
            return false;
        }
        TrapdoorCollision other = (TrapdoorCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Direction this$facing = this.facing;
        Direction other$facing = other.facing;
        return !(this$facing == null ? other$facing != null : !((Object)((Object)this$facing)).equals((Object)other$facing));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TrapdoorCollision;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Direction $facing = this.facing;
        result = result * 59 + ($facing == null ? 43 : ((Object)((Object)$facing)).hashCode());
        return result;
    }
}

