/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.CrafterContainer;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.updater.CrafterInventoryUpdater;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;

public class CrafterInventoryTranslator
extends AbstractBlockInventoryTranslator<CrafterContainer> {
    public static final int JAVA_RESULT_SLOT = 45;
    public static final int BEDROCK_RESULT_SLOT = 50;
    public static final int GRID_SIZE = 9;
    private static final int SLOT_ENABLED = 0;
    private static final int TRIGGERED_KEY = 9;
    private static final int TRIGGERED = 1;

    public CrafterInventoryTranslator() {
        super(10, Blocks.CRAFTER, ContainerType.CRAFTER, (InventoryUpdater)CrafterInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    public void updateProperty(GeyserSession session, CrafterContainer container, int key, int value) {
        if (key == 9) {
            container.setTriggered(value == 1);
        } else {
            container.setSlot(key, value == 0);
        }
        CrafterInventoryTranslator.updateBlockEntity(session, container);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        int slot = slotInfoData.getSlot();
        switch (slotInfoData.getContainerName().getContainer()) {
            case HOTBAR_AND_INVENTORY: 
            case HOTBAR: 
            case INVENTORY: {
                if (slot >= 9) {
                    return slot + 9 - 9;
                }
                return slot + 9 + 27;
            }
        }
        return slot;
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        if (slot == 45) {
            return 50;
        }
        if (slot < 9) {
            return slot;
        }
        int tmp = slot - 9;
        if (tmp < 27) {
            return tmp + 9;
        }
        return tmp - 27;
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int javaSlot, CrafterContainer container) {
        if (javaSlot == 45) {
            return new BedrockContainerSlot(ContainerSlotType.CRAFTER_BLOCK_CONTAINER, 50);
        }
        if (javaSlot < 9) {
            return new BedrockContainerSlot(ContainerSlotType.LEVEL_ENTITY, javaSlot);
        }
        int tmp = javaSlot - 9;
        if (tmp < 27) {
            return new BedrockContainerSlot(ContainerSlotType.INVENTORY, tmp + 9);
        }
        return new BedrockContainerSlot(ContainerSlotType.HOTBAR, tmp - 27);
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        if (javaSlot == 45) {
            return SlotType.OUTPUT;
        }
        return SlotType.NORMAL;
    }

    @Override
    public CrafterContainer createInventory(GeyserSession session, String name, int windowId, org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType containerType) {
        return new CrafterContainer(session, name, windowId, this.size, containerType);
    }

    private static void updateBlockEntity(GeyserSession session, CrafterContainer container) {
        NbtMapBuilder tag = NbtMap.builder();
        tag.putInt("crafting_ticks_remaining", container.isTriggered() ? 10000 : 0);
        tag.putShort("disabled_slots", container.getDisabledSlotsMask());
        BlockEntityUtils.updateBlockEntity(session, tag.build(), container.getHolderPosition());
    }

    @Override
    public ContainerType closeContainerType(CrafterContainer container) {
        return null;
    }
}

