/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.PathPackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.ResourcePackManifest;
import org.geysermc.geyser.api.pack.UrlPackCodec;
import org.geysermc.geyser.api.pack.exception.ResourcePackException;
import org.geysermc.geyser.api.pack.option.PriorityOption;
import org.geysermc.geyser.event.type.GeyserDefineResourcePacksEventImpl;
import org.geysermc.geyser.pack.GeyserResourcePack;
import org.geysermc.geyser.pack.ResourcePackHolder;
import org.geysermc.geyser.registry.loader.ResourcePackLoader;

public interface GeyserIntegratedPackUtil {
    public static final Path CACHE = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache");
    public static final Path PACK_PATH = CACHE.resolve("GeyserIntegratedPack.mcpack");
    public static final UUID OPTIONAL_PACK_UUID = UUID.fromString("e5f5c938-a701-11eb-b2a3-047d7bb283ba");
    public static final UUID INTEGRATED_PACK_UUID = UUID.fromString("2254393d-8430-45b0-838a-bd397828c765");
    public static final AtomicReference<ResourcePackManifest.Version> INTEGRATED_PACK_VERSION = new AtomicReference();
    public static final AtomicBoolean PACK_ENABLED = new AtomicBoolean(GeyserImpl.getInstance().config().gameplay().enableIntegratedPack());

    default public void registerGeyserPack(GeyserDefineResourcePacksEventImpl event) {
        if (!GeyserImpl.getInstance().config().gameplay().enableIntegratedPack()) {
            return;
        }
        try {
            Files.createDirectories(CACHE, new FileAttribute[0]);
            Files.copy(GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("GeyserIntegratedPack.mcpack"), PACK_PATH, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Could not copy over Geyser integrated resource pack!", e);
            PACK_ENABLED.set(false);
            return;
        }
        GeyserResourcePack integrated = ResourcePackLoader.readPack(PACK_PATH).build();
        INTEGRATED_PACK_VERSION.set(integrated.manifest().header().version());
        try {
            event.getPacks().put(INTEGRATED_PACK_UUID, ResourcePackHolder.of(integrated));
            event.registerOptions(INTEGRATED_PACK_UUID, PriorityOption.LOW);
            PACK_ENABLED.set(true);
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Could not register GeyserIntegratedPack!", e);
            PACK_ENABLED.set(false);
        }
    }

    default public void preProcessPack(GeyserResourcePack pack) {
        if (!PACK_ENABLED.get()) {
            return;
        }
        if (Objects.equals(pack.uuid(), INTEGRATED_PACK_UUID)) {
            this.handleDuplicateIntegratedPack(pack);
            return;
        }
        if (Objects.equals(pack.uuid(), OPTIONAL_PACK_UUID)) {
            this.handleOptionalPack(pack);
        }
    }

    default public void handleDuplicateIntegratedPack(ResourcePack duplicate) {
        ResourcePackManifest.Version version = duplicate.manifest().header().version();
        if (duplicate.codec() instanceof UrlPackCodec) {
            if (Objects.equals(version, INTEGRATED_PACK_VERSION.get())) {
                GeyserImpl.getInstance().getLogger().debug("Found GeyserIntegratedPack sent via UrlPackCodec (version: %s)!".formatted(version));
            } else {
                GeyserImpl.getInstance().getLogger().warning("Found GeyserIntegratedPack sent via UrlPackCodec, but the version differs! " + "(found: %s, expected: %s). Skipping our own, but things may not work as expected!".formatted(duplicate, INTEGRATED_PACK_VERSION.get()));
            }
            this.unregisterIntegratedPack();
            PACK_ENABLED.set(true);
            return;
        }
        throw new ResourcePackException(ResourcePackException.Cause.DUPLICATE);
    }

    default public void handleOptionalPack(ResourcePack pack) {
        if (pack.codec() instanceof UrlPackCodec) {
            GeyserImpl.getInstance().getLogger().warning("Detected GeyserOptionalPack sent via the UrlPackCodec! Please migrate to sending the GeyserIntegratedPack instead - it will be required in the future for advanced features to work correctly!");
        } else {
            GeyserImpl.getInstance().getLogger().warning("Detected GeyserOptionalPack! It should be removed " + this.warnMessageLocation(pack.codec()) + ", as Geyser now includes an improved version of this resource pack by default!");
        }
        GeyserImpl.getInstance().getLogger().warning("Disabling the integrated pack...");
        this.unregisterIntegratedPack();
        PACK_ENABLED.set(false);
    }

    default public String warnMessageLocation(PackCodec codec) {
        if (codec instanceof PathPackCodec) {
            PathPackCodec pathPackCodec = (PathPackCodec)codec;
            try {
                return "(found in: %s)".formatted(GeyserImpl.getInstance().getBootstrap().getConfigFolder().relativize(pathPackCodec.path()));
            }
            catch (Exception e) {
                return "(found in: %s)".formatted(pathPackCodec.path());
            }
        }
        return "(registered with codec: %s)".formatted(codec);
    }

    public void unregisterIntegratedPack();

    public boolean integratedPackRegistered();

    default public boolean isIntegratedPackActive() {
        return GeyserImpl.getInstance().config().gameplay().enableIntegratedPack() && this.integratedPackRegistered();
    }
}

