/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import marcono1234.gson.recordadapter.RecordTypeAdapterFactory;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.pack.GeyserResourcePackManifest;

public final class JsonUtils {
    public static <T> T fromJson(byte[] bytes, Class<T> type) {
        return (T)GeyserImpl.GSON.fromJson(new String(bytes, StandardCharsets.UTF_8), type);
    }

    public static JsonObject fromJson(InputStream stream) {
        return (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(stream));
    }

    public static JsonObject parseJson(String s) {
        JsonElement output = new JsonParser().parse(s);
        if (output instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)output;
            return jsonObject;
        }
        throw new IllegalArgumentException("Invalid JSON: " + s);
    }

    public static <T> T fromJson(InputStream stream, Type type) {
        return (T)GeyserImpl.GSON.fromJson((Reader)new InputStreamReader(stream), type);
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        try {
            new Gson().fromJson("{\"version\":[1,0,0],\"uuid\":\"eebb4ea8-a701-11eb-95ba-047d7bb283ba\"}", GeyserResourcePackManifest.Dependency.class);
        }
        catch (Throwable e) {
            builder.registerTypeAdapterFactory((TypeAdapterFactory)RecordTypeAdapterFactory.builder().allowMissingComponentValues().create()).registerTypeAdapter(GeyserResourcePackManifest.Version.class, (Object)new GeyserResourcePackManifest.Version.VersionDeserializer());
        }
        return builder.create();
    }

    private JsonUtils() {
    }
}

