/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import org.checkerframework.checker.nullness.qual.NonNull;

public record AttackRange(float minRange, float maxRange, float minCreativeRange, float maxCreativeRange, float hitboxMargin, float mobFactor) {
    public static @NonNull AttackRangeBuilder builder() {
        return new AttackRangeBuilder();
    }

    public @NonNull AttackRangeBuilder toBuilder() {
        return new AttackRangeBuilder().minRange(this.minRange).maxRange(this.maxRange).minCreativeRange(this.minCreativeRange).maxCreativeRange(this.maxCreativeRange).hitboxMargin(this.hitboxMargin).mobFactor(this.mobFactor);
    }

    public static class AttackRangeBuilder {
        private float minRange;
        private float maxRange;
        private float minCreativeRange;
        private float maxCreativeRange;
        private float hitboxMargin;
        private float mobFactor;

        AttackRangeBuilder() {
        }

        public @NonNull AttackRangeBuilder minRange(float minRange) {
            this.minRange = minRange;
            return this;
        }

        public @NonNull AttackRangeBuilder maxRange(float maxRange) {
            this.maxRange = maxRange;
            return this;
        }

        public @NonNull AttackRangeBuilder minCreativeRange(float minCreativeRange) {
            this.minCreativeRange = minCreativeRange;
            return this;
        }

        public @NonNull AttackRangeBuilder maxCreativeRange(float maxCreativeRange) {
            this.maxCreativeRange = maxCreativeRange;
            return this;
        }

        public @NonNull AttackRangeBuilder hitboxMargin(float hitboxMargin) {
            this.hitboxMargin = hitboxMargin;
            return this;
        }

        public @NonNull AttackRangeBuilder mobFactor(float mobFactor) {
            this.mobFactor = mobFactor;
            return this;
        }

        public @NonNull AttackRange build() {
            return new AttackRange(this.minRange, this.maxRange, this.minCreativeRange, this.maxCreativeRange, this.hitboxMargin, this.mobFactor);
        }

        public @NonNull String toString() {
            return "AttackRange.AttackRangeBuilder(minRange=" + this.minRange + ", maxRange=" + this.maxRange + ", minCreativeRange=" + this.minCreativeRange + ", maxCreativeRange=" + this.maxCreativeRange + ", hitboxMargin=" + this.hitboxMargin + ", mobFactor=" + this.mobFactor + ")";
        }
    }
}

