/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ConsumeEffect;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;

public record Consumable(float consumeSeconds, ItemUseAnimation animation, Sound sound, boolean hasConsumeParticles, List<ConsumeEffect> onConsumeEffects) {
    public Consumable(float consumeSeconds, ItemUseAnimation animation, Sound sound, boolean hasConsumeParticles, List<ConsumeEffect> onConsumeEffects) {
        this.consumeSeconds = consumeSeconds;
        this.animation = animation;
        this.sound = sound;
        this.hasConsumeParticles = hasConsumeParticles;
        this.onConsumeEffects = List.copyOf(onConsumeEffects);
    }

    public static @NonNull ConsumableBuilder builder() {
        return new ConsumableBuilder();
    }

    public @NonNull ConsumableBuilder toBuilder() {
        return new ConsumableBuilder().consumeSeconds(this.consumeSeconds).animation(this.animation).sound(this.sound).hasConsumeParticles(this.hasConsumeParticles).onConsumeEffects(this.onConsumeEffects);
    }

    public static enum ItemUseAnimation {
        NONE,
        EAT,
        DRINK,
        BLOCK,
        BOW,
        TRIDENT,
        CROSSBOW,
        SPYGLASS,
        TOOT_HORN,
        BRUSH,
        BUNDLE,
        SPEAR;

        private static final ItemUseAnimation[] VALUES;

        public static ItemUseAnimation from(int id) {
            return VALUES[id];
        }

        static {
            VALUES = ItemUseAnimation.values();
        }
    }

    public static class ConsumableBuilder {
        private float consumeSeconds;
        private ItemUseAnimation animation;
        private Sound sound;
        private boolean hasConsumeParticles;
        private List<ConsumeEffect> onConsumeEffects;

        ConsumableBuilder() {
        }

        public @NonNull ConsumableBuilder consumeSeconds(float consumeSeconds) {
            this.consumeSeconds = consumeSeconds;
            return this;
        }

        public @NonNull ConsumableBuilder animation(ItemUseAnimation animation) {
            this.animation = animation;
            return this;
        }

        public @NonNull ConsumableBuilder sound(Sound sound) {
            this.sound = sound;
            return this;
        }

        public @NonNull ConsumableBuilder hasConsumeParticles(boolean hasConsumeParticles) {
            this.hasConsumeParticles = hasConsumeParticles;
            return this;
        }

        public @NonNull ConsumableBuilder onConsumeEffects(List<ConsumeEffect> onConsumeEffects) {
            this.onConsumeEffects = onConsumeEffects;
            return this;
        }

        public @NonNull Consumable build() {
            return new Consumable(this.consumeSeconds, this.animation, this.sound, this.hasConsumeParticles, this.onConsumeEffects);
        }

        public @NonNull String toString() {
            return "Consumable.ConsumableBuilder(consumeSeconds=" + this.consumeSeconds + ", animation=" + String.valueOf((Object)this.animation) + ", sound=" + String.valueOf(this.sound) + ", hasConsumeParticles=" + this.hasConsumeParticles + ", onConsumeEffects=" + String.valueOf(this.onConsumeEffects) + ")";
        }
    }
}

