/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import org.checkerframework.checker.nullness.qual.NonNull;

public record SwingAnimation(Type type, int duration) {
    public static @NonNull SwingAnimationBuilder builder() {
        return new SwingAnimationBuilder();
    }

    public @NonNull SwingAnimationBuilder toBuilder() {
        return new SwingAnimationBuilder().type(this.type).duration(this.duration);
    }

    public static enum Type {
        NONE,
        WHACK,
        STAB;

        private static final Type[] VALUES;

        public static Type from(int id) {
            return id >= 0 && id < VALUES.length ? VALUES[id] : VALUES[0];
        }

        static {
            VALUES = Type.values();
        }
    }

    public static class SwingAnimationBuilder {
        private Type type;
        private int duration;

        SwingAnimationBuilder() {
        }

        public @NonNull SwingAnimationBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public @NonNull SwingAnimationBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public @NonNull SwingAnimation build() {
            return new SwingAnimation(this.type, this.duration);
        }

        public @NonNull String toString() {
            return "SwingAnimation.SwingAnimationBuilder(type=" + String.valueOf((Object)this.type) + ", duration=" + this.duration + ")";
        }
    }
}

