/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.level.particle.positionsource;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.positionsource.PositionSource;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.positionsource.PositionSourceType;

public final class EntityPositionSource
implements PositionSource {
    private final int entityId;
    private final float yOffset;

    @Override
    public PositionSourceType getType() {
        return PositionSourceType.ENTITY;
    }

    public EntityPositionSource(int entityId, float yOffset) {
        this.entityId = entityId;
        this.yOffset = yOffset;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityPositionSource)) {
            return false;
        }
        EntityPositionSource other = (EntityPositionSource)o;
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Float.compare(this.getYOffset(), other.getYOffset()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Float.floatToIntBits(this.getYOffset());
        return result;
    }

    public @NonNull String toString() {
        return "EntityPositionSource(entityId=" + this.getEntityId() + ", yOffset=" + this.getYOffset() + ")";
    }
}

