/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundPlayerInfoRemovePacket
implements MinecraftPacket {
    private final List<UUID> profileIds;

    public ClientboundPlayerInfoRemovePacket(ByteBuf in) {
        this.profileIds = MinecraftTypes.readList(in, MinecraftTypes::readUUID);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeList(out, this.profileIds, MinecraftTypes::writeUUID);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public List<UUID> getProfileIds() {
        return this.profileIds;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerInfoRemovePacket)) {
            return false;
        }
        ClientboundPlayerInfoRemovePacket other = (ClientboundPlayerInfoRemovePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UUID> this$profileIds = this.getProfileIds();
        List<UUID> other$profileIds = other.getProfileIds();
        return !(this$profileIds == null ? other$profileIds != null : !((Object)this$profileIds).equals(other$profileIds));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundPlayerInfoRemovePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UUID> $profileIds = this.getProfileIds();
        result = result * 59 + ($profileIds == null ? 43 : ((Object)$profileIds).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundPlayerInfoRemovePacket(profileIds=" + String.valueOf(this.getProfileIds()) + ")";
    }

    public @NonNull ClientboundPlayerInfoRemovePacket withProfileIds(List<UUID> profileIds) {
        return this.profileIds == profileIds ? this : new ClientboundPlayerInfoRemovePacket(profileIds);
    }

    public ClientboundPlayerInfoRemovePacket(List<UUID> profileIds) {
        this.profileIds = profileIds;
    }
}

