/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3d;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PositionElement;

public class ClientboundTeleportEntityPacket
implements MinecraftPacket {
    private final int id;
    private final Vector3d position;
    private final Vector3d deltaMovement;
    private final float yRot;
    private final float xRot;
    @lombok.NonNull
    private final List<PositionElement> relatives;
    private final boolean onGround;

    public ClientboundTeleportEntityPacket(ByteBuf in) {
        this.id = MinecraftTypes.readVarInt(in);
        this.position = Vector3d.from(in.readDouble(), in.readDouble(), in.readDouble());
        this.deltaMovement = Vector3d.from(in.readDouble(), in.readDouble(), in.readDouble());
        this.yRot = in.readFloat();
        this.xRot = in.readFloat();
        this.relatives = new ArrayList<PositionElement>();
        int flags = in.readInt();
        for (PositionElement element : PositionElement.values()) {
            int bit = 1 << element.ordinal();
            if ((flags & bit) != bit) continue;
            this.relatives.add(element);
        }
        this.onGround = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.id);
        out.writeDouble(this.position.getX());
        out.writeDouble(this.position.getY());
        out.writeDouble(this.position.getZ());
        out.writeDouble(this.deltaMovement.getX());
        out.writeDouble(this.deltaMovement.getY());
        out.writeDouble(this.deltaMovement.getZ());
        out.writeFloat(this.yRot);
        out.writeFloat(this.xRot);
        int flags = 0;
        for (PositionElement element : this.relatives) {
            flags |= 1 << element.ordinal();
        }
        out.writeInt(flags);
        out.writeBoolean(this.onGround);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getId() {
        return this.id;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public Vector3d getDeltaMovement() {
        return this.deltaMovement;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }

    @lombok.NonNull
    public List<PositionElement> getRelatives() {
        return this.relatives;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundTeleportEntityPacket)) {
            return false;
        }
        ClientboundTeleportEntityPacket other = (ClientboundTeleportEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (Float.compare(this.getYRot(), other.getYRot()) != 0) {
            return false;
        }
        if (Float.compare(this.getXRot(), other.getXRot()) != 0) {
            return false;
        }
        if (this.isOnGround() != other.isOnGround()) {
            return false;
        }
        Vector3d this$position = this.getPosition();
        Vector3d other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Vector3d this$deltaMovement = this.getDeltaMovement();
        Vector3d other$deltaMovement = other.getDeltaMovement();
        if (this$deltaMovement == null ? other$deltaMovement != null : !this$deltaMovement.equals(other$deltaMovement)) {
            return false;
        }
        List<PositionElement> this$relatives = this.getRelatives();
        List<PositionElement> other$relatives = other.getRelatives();
        return !(this$relatives == null ? other$relatives != null : !((Object)this$relatives).equals(other$relatives));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundTeleportEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + Float.floatToIntBits(this.getYRot());
        result = result * 59 + Float.floatToIntBits(this.getXRot());
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        Vector3d $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Vector3d $deltaMovement = this.getDeltaMovement();
        result = result * 59 + ($deltaMovement == null ? 43 : $deltaMovement.hashCode());
        List<PositionElement> $relatives = this.getRelatives();
        result = result * 59 + ($relatives == null ? 43 : ((Object)$relatives).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundTeleportEntityPacket(id=" + this.getId() + ", position=" + String.valueOf(this.getPosition()) + ", deltaMovement=" + String.valueOf(this.getDeltaMovement()) + ", yRot=" + this.getYRot() + ", xRot=" + this.getXRot() + ", relatives=" + String.valueOf(this.getRelatives()) + ", onGround=" + this.isOnGround() + ")";
    }

    public @NonNull ClientboundTeleportEntityPacket withId(int id) {
        return this.id == id ? this : new ClientboundTeleportEntityPacket(id, this.position, this.deltaMovement, this.yRot, this.xRot, this.relatives, this.onGround);
    }

    public @NonNull ClientboundTeleportEntityPacket withPosition(Vector3d position) {
        return this.position == position ? this : new ClientboundTeleportEntityPacket(this.id, position, this.deltaMovement, this.yRot, this.xRot, this.relatives, this.onGround);
    }

    public @NonNull ClientboundTeleportEntityPacket withDeltaMovement(Vector3d deltaMovement) {
        return this.deltaMovement == deltaMovement ? this : new ClientboundTeleportEntityPacket(this.id, this.position, deltaMovement, this.yRot, this.xRot, this.relatives, this.onGround);
    }

    public @NonNull ClientboundTeleportEntityPacket withYRot(float yRot) {
        return this.yRot == yRot ? this : new ClientboundTeleportEntityPacket(this.id, this.position, this.deltaMovement, yRot, this.xRot, this.relatives, this.onGround);
    }

    public @NonNull ClientboundTeleportEntityPacket withXRot(float xRot) {
        return this.xRot == xRot ? this : new ClientboundTeleportEntityPacket(this.id, this.position, this.deltaMovement, this.yRot, xRot, this.relatives, this.onGround);
    }

    public @NonNull ClientboundTeleportEntityPacket withRelatives(@lombok.NonNull List<PositionElement> relatives) {
        if (relatives == null) {
            throw new NullPointerException("relatives is marked non-null but is null");
        }
        return this.relatives == relatives ? this : new ClientboundTeleportEntityPacket(this.id, this.position, this.deltaMovement, this.yRot, this.xRot, relatives, this.onGround);
    }

    public @NonNull ClientboundTeleportEntityPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ClientboundTeleportEntityPacket(this.id, this.position, this.deltaMovement, this.yRot, this.xRot, this.relatives, onGround);
    }

    public ClientboundTeleportEntityPacket(int id, Vector3d position, Vector3d deltaMovement, float yRot, float xRot, @lombok.NonNull List<PositionElement> relatives, boolean onGround) {
        if (relatives == null) {
            throw new NullPointerException("relatives is marked non-null but is null");
        }
        this.id = id;
        this.position = position;
        this.deltaMovement = deltaMovement;
        this.yRot = yRot;
        this.xRot = xRot;
        this.relatives = relatives;
        this.onGround = onGround;
    }
}

