/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.border;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundSetBorderWarningDistancePacket
implements MinecraftPacket {
    private final int warningBlocks;

    public ClientboundSetBorderWarningDistancePacket(ByteBuf in) {
        this.warningBlocks = MinecraftTypes.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.warningBlocks);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getWarningBlocks() {
        return this.warningBlocks;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetBorderWarningDistancePacket)) {
            return false;
        }
        ClientboundSetBorderWarningDistancePacket other = (ClientboundSetBorderWarningDistancePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getWarningBlocks() == other.getWarningBlocks();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetBorderWarningDistancePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWarningBlocks();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetBorderWarningDistancePacket(warningBlocks=" + this.getWarningBlocks() + ")";
    }

    public @NonNull ClientboundSetBorderWarningDistancePacket withWarningBlocks(int warningBlocks) {
        return this.warningBlocks == warningBlocks ? this : new ClientboundSetBorderWarningDistancePacket(warningBlocks);
    }

    public ClientboundSetBorderWarningDistancePacket(int warningBlocks) {
        this.warningBlocks = warningBlocks;
    }
}

