/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.method;

import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.builder.matcher.MethodMatcher;
import io.papermc.asm.rules.method.MethodRewriteRule;
import io.papermc.asm.rules.method.OwnableMethodRewriteRule;
import io.papermc.asm.util.DescriptorUtils;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Set;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MethodRewrites {
    private MethodRewrites() {
    }

    public record SubTypeReturn(Set<ClassDesc> owners, MethodMatcher methodMatcher, ClassDesc oldReturnType, ClassDesc newReturnType) implements OwnableMethodRewriteRule.Filtered
    {
        @Override
        public @Nullable MethodRewriteRule.Rewrite<?> rewrite(ClassProcessingContext context, boolean isInvokeDynamic, int opcode, ClassDesc owner, String name, MethodTypeDesc descriptor, boolean isInterface) {
            if (!descriptor.returnType().equals(this.newReturnType())) {
                return new MethodRewriteRule.RewriteSingle(opcode, owner, name, this.modifyMethodDescriptor(descriptor), isInterface, isInvokeDynamic);
            }
            return null;
        }

        private MethodTypeDesc modifyMethodDescriptor(MethodTypeDesc methodDescriptor) {
            return methodDescriptor.changeReturnType(this.newReturnType());
        }
    }

    public record SuperTypeParam(Set<ClassDesc> owners, MethodMatcher methodMatcher, ClassDesc oldParamType, ClassDesc newParamType) implements OwnableMethodRewriteRule.Filtered
    {
        @Override
        public MethodRewriteRule.Rewrite<?> rewrite(ClassProcessingContext context, boolean isInvokeDynamic, int opcode, ClassDesc owner, String name, MethodTypeDesc descriptor, boolean isInterface) {
            return new MethodRewriteRule.RewriteSingle(opcode, owner, name, this.modifyMethodDescriptor(descriptor), isInterface, isInvokeDynamic);
        }

        private MethodTypeDesc modifyMethodDescriptor(MethodTypeDesc methodDescriptor) {
            return DescriptorUtils.replaceParameters(methodDescriptor, Predicate.isEqual(this.oldParamType()), this.newParamType());
        }
    }
}

